@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allowForcePush Whether force push is allowed.
 * @property codeOwnerApprovalRequired Reject code pushes that change files listed in the CODEOWNERS file.
 * @property id The ID of this resource.
 * @property mergeAccessLevels Array of access levels and user(s)/group(s) allowed to merge to protected branch.
 * @property name The name of the protected branch.
 * @property pushAccessLevels Array of access levels and user(s)/group(s) allowed to push to protected branch.
 */
public data class GetProjectProtectedBranchesProtectedBranch(
    public val allowForcePush: Boolean,
    public val codeOwnerApprovalRequired: Boolean,
    public val id: Int,
    public val mergeAccessLevels: List<GetProjectProtectedBranchesProtectedBranchMergeAccessLevel>? =
        null,
    public val name: String,
    public val pushAccessLevels: List<GetProjectProtectedBranchesProtectedBranchPushAccessLevel>? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectProtectedBranchesProtectedBranch): GetProjectProtectedBranchesProtectedBranch = GetProjectProtectedBranchesProtectedBranch(
            allowForcePush = javaType.allowForcePush(),
            codeOwnerApprovalRequired = javaType.codeOwnerApprovalRequired(),
            id = javaType.id(),
            mergeAccessLevels = javaType.mergeAccessLevels().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetProjectProtectedBranchesProtectedBranchMergeAccessLevel.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            pushAccessLevels = javaType.pushAccessLevels().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetProjectProtectedBranchesProtectedBranchPushAccessLevel.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
