@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessLevel Access levels allowed to merge to protected branch. Valid values are: `no one`, `developer`, `maintainer`.
 * @property accessLevelDescription Readable description of access level.
 * @property groupId The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
 * @property userId The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
 */
public data class GetProjectProtectedBranchesProtectedBranchMergeAccessLevel(
    public val accessLevel: String,
    public val accessLevelDescription: String,
    public val groupId: Int? = null,
    public val userId: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectProtectedBranchesProtectedBranchMergeAccessLevel): GetProjectProtectedBranchesProtectedBranchMergeAccessLevel =
            GetProjectProtectedBranchesProtectedBranchMergeAccessLevel(
                accessLevel = javaType.accessLevel(),
                accessLevelDescription = javaType.accessLevelDescription(),
                groupId = javaType.groupId().map({ args0 -> args0 }).orElse(null),
                userId = javaType.userId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
