@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getProjectProtectedBranches.
 * @property id The ID of this resource.
 * @property projectId The integer or path with namespace that uniquely identifies the project.
 * @property protectedBranches A list of protected branches, as defined below.
 */
public data class GetProjectProtectedBranchesResult(
    public val id: Int,
    public val projectId: String,
    public val protectedBranches: List<GetProjectProtectedBranchesProtectedBranch>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectProtectedBranchesResult): GetProjectProtectedBranchesResult = GetProjectProtectedBranchesResult(
            id = javaType.id(),
            projectId = javaType.projectId(),
            protectedBranches = javaType.protectedBranches().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetProjectProtectedBranchesProtectedBranch.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
