@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessLevel Access level allowed to create protected tags.
 * @property accessLevelDescription Readable description of access level.
 * @property groupId The ID of a GitLab group allowed to perform the relevant action.
 * @property id The ID of the create access level.
 * @property userId The ID of a GitLab user allowed to perform the relevant action.
 */
public data class GetProjectProtectedTagCreateAccessLevel(
    public val accessLevel: String,
    public val accessLevelDescription: String,
    public val groupId: Int? = null,
    public val id: Int,
    public val userId: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectProtectedTagCreateAccessLevel): GetProjectProtectedTagCreateAccessLevel = GetProjectProtectedTagCreateAccessLevel(
            accessLevel = javaType.accessLevel(),
            accessLevelDescription = javaType.accessLevelDescription(),
            groupId = javaType.groupId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            userId = javaType.userId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
