@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getProjectProtectedTag.
 * @property createAccessLevels Array of access levels/user(s)/group(s) allowed to create protected tags.
 * @property id The ID of this resource. In the format of `<tag>`.
 * @property project The integer or path with namespace that uniquely identifies the project.
 * @property tag The name of the protected tag.
 */
public data class GetProjectProtectedTagResult(
    public val createAccessLevels: List<GetProjectProtectedTagCreateAccessLevel>,
    public val id: String,
    public val project: String,
    public val tag: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectProtectedTagResult): GetProjectProtectedTagResult = GetProjectProtectedTagResult(
            createAccessLevels = javaType.createAccessLevels().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetProjectProtectedTagCreateAccessLevel.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            project = javaType.project(),
            tag = javaType.tag(),
        )
    }
}
