@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property createAccessLevels Array of access levels/user(s)/group(s) allowed to create protected tags.
 * @property tag The name of the protected tag.
 */
public data class GetProjectProtectedTagsProtectedTag(
    public val createAccessLevels: List<GetProjectProtectedTagsProtectedTagCreateAccessLevel>,
    public val tag: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectProtectedTagsProtectedTag): GetProjectProtectedTagsProtectedTag = GetProjectProtectedTagsProtectedTag(
            createAccessLevels = javaType.createAccessLevels().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetProjectProtectedTagsProtectedTagCreateAccessLevel.Companion.toKotlin(args0)
                })
            }),
            tag = javaType.tag(),
        )
    }
}
