@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getProjectProtectedTags.
 * @property id The ID of this resource.
 * @property project The integer or path with namespace that uniquely identifies the project.
 * @property protectedTags A list of protected tags, as defined below.
 */
public data class GetProjectProtectedTagsResult(
    public val id: String,
    public val project: String,
    public val protectedTags: List<GetProjectProtectedTagsProtectedTag>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectProtectedTagsResult): GetProjectProtectedTagsResult = GetProjectProtectedTagsResult(
            id = javaType.id(),
            project = javaType.project(),
            protectedTags = javaType.protectedTags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetProjectProtectedTagsProtectedTag.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
