@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authorEmailRegex All commit author emails must match this regex, e.g. `@my-company.com$`.
 * @property branchNameRegex All branch names must match this regex, e.g. `(feature|hotfix)\/*`.
 * @property commitCommitterCheck Users can only push commits to this repository that were committed with one of their own verified emails.
 * @property commitCommitterNameCheck Users can only push commits to this repository if the commit author name is consistent with their GitLab account name.
 * @property commitMessageNegativeRegex No commit message is allowed to match this regex, for example `ssh\:\/\/`.
 * @property commitMessageRegex All commit messages must match this regex, e.g. `Fixed \d+\..*`.
 * @property denyDeleteTag Deny deleting a tag.
 * @property fileNameRegex All committed filenames must not match this regex, e.g. `(jar|exe)$`.
 * @property maxFileSize Maximum file size (MB).
 * @property memberCheck Restrict commits by author (email) to existing GitLab users.
 * @property preventSecrets GitLab will reject any files that are likely to contain secrets.
 * @property rejectNonDcoCommits Reject commit when it’s not DCO certified.
 * @property rejectUnsignedCommits Reject commit when it’s not signed through GPG.
 * */
 */
public data class GetProjectPushRule(
    public val authorEmailRegex: String,
    public val branchNameRegex: String,
    public val commitCommitterCheck: Boolean,
    public val commitCommitterNameCheck: Boolean,
    public val commitMessageNegativeRegex: String,
    public val commitMessageRegex: String,
    public val denyDeleteTag: Boolean,
    public val fileNameRegex: String,
    public val maxFileSize: Int,
    public val memberCheck: Boolean,
    public val preventSecrets: Boolean,
    public val rejectNonDcoCommits: Boolean,
    public val rejectUnsignedCommits: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectPushRule): GetProjectPushRule = GetProjectPushRule(
            authorEmailRegex = javaType.authorEmailRegex(),
            branchNameRegex = javaType.branchNameRegex(),
            commitCommitterCheck = javaType.commitCommitterCheck(),
            commitCommitterNameCheck = javaType.commitCommitterNameCheck(),
            commitMessageNegativeRegex = javaType.commitMessageNegativeRegex(),
            commitMessageRegex = javaType.commitMessageRegex(),
            denyDeleteTag = javaType.denyDeleteTag(),
            fileNameRegex = javaType.fileNameRegex(),
            maxFileSize = javaType.maxFileSize(),
            memberCheck = javaType.memberCheck(),
            preventSecrets = javaType.preventSecrets(),
            rejectNonDcoCommits = javaType.rejectNonDcoCommits(),
            rejectUnsignedCommits = javaType.rejectUnsignedCommits(),
        )
    }
}
