@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getProject.
 * @property analyticsAccessLevel Set the analytics access level. Valid values are `disabled`, `private`, `enabled`.
 * @property archived Whether the project is in read-only mode (archived).
 * @property autoCancelPendingPipelines Auto-cancel pending pipelines. This isn’t a boolean, but enabled/disabled.
 * @property autoDevopsDeployStrategy Auto Deploy strategy. Valid values are `continuous`, `manual`, `timed_incremental`.
 * @property autoDevopsEnabled Enable Auto DevOps for this project.
 * @property autocloseReferencedIssues Set whether auto-closing referenced issues on default branch.
 * @property buildGitStrategy The Git strategy. Defaults to fetch.
 * @property buildTimeout The maximum amount of time, in seconds, that a job can run.
 * @property buildsAccessLevel Set the builds access level. Valid values are `disabled`, `private`, `enabled`.
 * @property ciConfigPath CI config file path for the project.
 * @property ciDefaultGitDepth Default number of revisions for shallow cloning.
 * @property ciRestrictPipelineCancellationRole The role required to cancel a pipeline or job. Introduced in GitLab 16.8. Premium and Ultimate only. Valid values are `developer`, `maintainer`, `no one`
 * @property ciSeparatedCaches Use separate caches for protected branches.
 * @property containerExpirationPolicies Set the image cleanup policy for this project. **Note**: this field is sometimes named `container_expiration_policy_attributes` in the GitLab Upstream API.
 * @property containerRegistryAccessLevel Set visibility of container registry, for this project. Valid values are `disabled`, `private`, `enabled`.
 * @property defaultBranch The default branch for the project.
 * @property description A description of the project.
 * @property emailsEnabled Enable email notifications.
 * @property emptyRepo Whether the project is empty.
 * @property environmentsAccessLevel Set the environments access level. Valid values are `disabled`, `private`, `enabled`.
 * @property externalAuthorizationClassificationLabel The classification label for the project.
 * @property featureFlagsAccessLevel Set the feature flags access level. Valid values are `disabled`, `private`, `enabled`.
 * @property forkingAccessLevel Set the forking access level. Valid values are `disabled`, `private`, `enabled`.
 * @property httpUrlToRepo URL that can be provided to `git clone` to clone the
 * @property id The integer that uniquely identifies the project within the gitlab install.
 * @property importUrl URL the project was imported from.
 * @property infrastructureAccessLevel Set the infrastructure access level. Valid values are `disabled`, `private`, `enabled`.
 * @property issuesAccessLevel Set the issues access level. Valid values are `disabled`, `private`, `enabled`.
 * @property issuesEnabled Enable issue tracking for the project.
 * @property keepLatestArtifact Disable or enable the ability to keep the latest artifact for this project.
 * @property lfsEnabled Enable LFS for the project.
 * @property mergeCommitTemplate Template used to create merge commit message in merge requests. (Introduced in GitLab 14.5.)
 * @property mergePipelinesEnabled Enable or disable merge pipelines.
 * @property mergeRequestsAccessLevel Set the merge requests access level. Valid values are `disabled`, `private`, `enabled`.
 * @property mergeRequestsEnabled Enable merge requests for the project.
 * @property mergeTrainsEnabled Enable or disable merge trains.
 * @property monitorAccessLevel Set the monitor access level. Valid values are `disabled`, `private`, `enabled`.
 * @property name The name of the project.
 * @property namespaceId The namespace (group or user) of the project. Defaults to your user.
 * @property path The path of the repository.
 * @property pathWithNamespace The path of the repository with namespace.
 * @property pipelinesEnabled Enable pipelines for the project.
 * @property printingMergeRequestLinkEnabled Show link to create/view merge request when pushing from the command line
 * @property publicBuilds If true, jobs can be viewed by non-project members.
 * @property pushRules Push rules for the project. Push rules are only available on Enterprise plans and if the authenticated has permissions to read them.
 * @property releasesAccessLevel Set the releases access level. Valid values are `disabled`, `private`, `enabled`.
 * @property removeSourceBranchAfterMerge Enable `Delete source branch` option by default for all new merge requests
 * @property repositoryAccessLevel Set the repository access level. Valid values are `disabled`, `private`, `enabled`.
 * @property repositoryStorage Which storage shard the repository is on. (administrator only)
 * @property requestAccessEnabled Allow users to request member access.
 * @property requirementsAccessLevel Set the requirements access level. Valid values are `disabled`, `private`, `enabled`.
 * @property resolveOutdatedDiffDiscussions Automatically resolve merge request diffs discussions on lines changed with a push.
 * @property restrictUserDefinedVariables Allow only users with the Maintainer role to pass user-defined variables when triggering a pipeline.
 * @property runnersToken Registration token to use during runner setup.
 * @property securityAndComplianceAccessLevel Set the security and compliance access level. Valid values are `disabled`, `private`, `enabled`.
 * @property sharedWithGroups Describes groups which have access shared to this project.
 * @property snippetsAccessLevel Set the snippets access level. Valid values are `disabled`, `private`, `enabled`.
 * @property snippetsEnabled Enable snippets for the project.
 * @property squashCommitTemplate Template used to create squash commit message in merge requests. (Introduced in GitLab 14.6.)
 * @property sshUrlToRepo URL that can be provided to `git clone` to clone the
 * @property suggestionCommitMessage The commit message used to apply merge request suggestions.
 * @property topics The list of topics for the project.
 * @property visibilityLevel Repositories are created as private by default.
 * @property webUrl URL that can be used to find the project in a browser.
 * @property wikiAccessLevel Set the wiki access level. Valid values are `disabled`, `private`, `enabled`.
 * @property wikiEnabled Enable wiki for the project.
 */
public data class GetProjectResult(
    public val analyticsAccessLevel: String,
    public val archived: Boolean,
    public val autoCancelPendingPipelines: String,
    public val autoDevopsDeployStrategy: String,
    public val autoDevopsEnabled: Boolean,
    public val autocloseReferencedIssues: Boolean,
    public val buildGitStrategy: String,
    public val buildTimeout: Int,
    public val buildsAccessLevel: String,
    public val ciConfigPath: String,
    public val ciDefaultGitDepth: Int,
    public val ciRestrictPipelineCancellationRole: String,
    public val ciSeparatedCaches: Boolean,
    public val containerExpirationPolicies: List<GetProjectContainerExpirationPolicy>,
    public val containerRegistryAccessLevel: String,
    public val defaultBranch: String,
    public val description: String,
    public val emailsEnabled: Boolean,
    public val emptyRepo: Boolean,
    public val environmentsAccessLevel: String,
    public val externalAuthorizationClassificationLabel: String,
    public val featureFlagsAccessLevel: String,
    public val forkingAccessLevel: String,
    public val httpUrlToRepo: String,
    public val id: String,
    public val importUrl: String,
    public val infrastructureAccessLevel: String,
    public val issuesAccessLevel: String,
    public val issuesEnabled: Boolean,
    public val keepLatestArtifact: Boolean,
    public val lfsEnabled: Boolean,
    public val mergeCommitTemplate: String,
    public val mergePipelinesEnabled: Boolean,
    public val mergeRequestsAccessLevel: String,
    public val mergeRequestsEnabled: Boolean,
    public val mergeTrainsEnabled: Boolean,
    public val monitorAccessLevel: String,
    public val name: String,
    public val namespaceId: Int,
    public val path: String,
    public val pathWithNamespace: String,
    public val pipelinesEnabled: Boolean,
    public val printingMergeRequestLinkEnabled: Boolean,
    public val publicBuilds: Boolean? = null,
    public val pushRules: List<GetProjectPushRule>,
    public val releasesAccessLevel: String,
    public val removeSourceBranchAfterMerge: Boolean,
    public val repositoryAccessLevel: String,
    public val repositoryStorage: String,
    public val requestAccessEnabled: Boolean,
    public val requirementsAccessLevel: String,
    public val resolveOutdatedDiffDiscussions: Boolean,
    public val restrictUserDefinedVariables: Boolean,
    public val runnersToken: String,
    public val securityAndComplianceAccessLevel: String,
    public val sharedWithGroups: List<GetProjectSharedWithGroup>,
    public val snippetsAccessLevel: String,
    public val snippetsEnabled: Boolean,
    public val squashCommitTemplate: String,
    public val sshUrlToRepo: String,
    public val suggestionCommitMessage: String,
    public val topics: List<String>,
    public val visibilityLevel: String,
    public val webUrl: String,
    public val wikiAccessLevel: String,
    public val wikiEnabled: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectResult): GetProjectResult =
            GetProjectResult(
                analyticsAccessLevel = javaType.analyticsAccessLevel(),
                archived = javaType.archived(),
                autoCancelPendingPipelines = javaType.autoCancelPendingPipelines(),
                autoDevopsDeployStrategy = javaType.autoDevopsDeployStrategy(),
                autoDevopsEnabled = javaType.autoDevopsEnabled(),
                autocloseReferencedIssues = javaType.autocloseReferencedIssues(),
                buildGitStrategy = javaType.buildGitStrategy(),
                buildTimeout = javaType.buildTimeout(),
                buildsAccessLevel = javaType.buildsAccessLevel(),
                ciConfigPath = javaType.ciConfigPath(),
                ciDefaultGitDepth = javaType.ciDefaultGitDepth(),
                ciRestrictPipelineCancellationRole = javaType.ciRestrictPipelineCancellationRole(),
                ciSeparatedCaches = javaType.ciSeparatedCaches(),
                containerExpirationPolicies = javaType.containerExpirationPolicies().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.gitlab.kotlin.outputs.GetProjectContainerExpirationPolicy.Companion.toKotlin(args0)
                    })
                }),
                containerRegistryAccessLevel = javaType.containerRegistryAccessLevel(),
                defaultBranch = javaType.defaultBranch(),
                description = javaType.description(),
                emailsEnabled = javaType.emailsEnabled(),
                emptyRepo = javaType.emptyRepo(),
                environmentsAccessLevel = javaType.environmentsAccessLevel(),
                externalAuthorizationClassificationLabel = javaType.externalAuthorizationClassificationLabel(),
                featureFlagsAccessLevel = javaType.featureFlagsAccessLevel(),
                forkingAccessLevel = javaType.forkingAccessLevel(),
                httpUrlToRepo = javaType.httpUrlToRepo(),
                id = javaType.id(),
                importUrl = javaType.importUrl(),
                infrastructureAccessLevel = javaType.infrastructureAccessLevel(),
                issuesAccessLevel = javaType.issuesAccessLevel(),
                issuesEnabled = javaType.issuesEnabled(),
                keepLatestArtifact = javaType.keepLatestArtifact(),
                lfsEnabled = javaType.lfsEnabled(),
                mergeCommitTemplate = javaType.mergeCommitTemplate(),
                mergePipelinesEnabled = javaType.mergePipelinesEnabled(),
                mergeRequestsAccessLevel = javaType.mergeRequestsAccessLevel(),
                mergeRequestsEnabled = javaType.mergeRequestsEnabled(),
                mergeTrainsEnabled = javaType.mergeTrainsEnabled(),
                monitorAccessLevel = javaType.monitorAccessLevel(),
                name = javaType.name(),
                namespaceId = javaType.namespaceId(),
                path = javaType.path(),
                pathWithNamespace = javaType.pathWithNamespace(),
                pipelinesEnabled = javaType.pipelinesEnabled(),
                printingMergeRequestLinkEnabled = javaType.printingMergeRequestLinkEnabled(),
                publicBuilds = javaType.publicBuilds().map({ args0 -> args0 }).orElse(null),
                pushRules = javaType.pushRules().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.gitlab.kotlin.outputs.GetProjectPushRule.Companion.toKotlin(args0)
                    })
                }),
                releasesAccessLevel = javaType.releasesAccessLevel(),
                removeSourceBranchAfterMerge = javaType.removeSourceBranchAfterMerge(),
                repositoryAccessLevel = javaType.repositoryAccessLevel(),
                repositoryStorage = javaType.repositoryStorage(),
                requestAccessEnabled = javaType.requestAccessEnabled(),
                requirementsAccessLevel = javaType.requirementsAccessLevel(),
                resolveOutdatedDiffDiscussions = javaType.resolveOutdatedDiffDiscussions(),
                restrictUserDefinedVariables = javaType.restrictUserDefinedVariables(),
                runnersToken = javaType.runnersToken(),
                securityAndComplianceAccessLevel = javaType.securityAndComplianceAccessLevel(),
                sharedWithGroups = javaType.sharedWithGroups().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.gitlab.kotlin.outputs.GetProjectSharedWithGroup.Companion.toKotlin(args0)
                    })
                }),
                snippetsAccessLevel = javaType.snippetsAccessLevel(),
                snippetsEnabled = javaType.snippetsEnabled(),
                squashCommitTemplate = javaType.squashCommitTemplate(),
                sshUrlToRepo = javaType.sshUrlToRepo(),
                suggestionCommitMessage = javaType.suggestionCommitMessage(),
                topics = javaType.topics().map({ args0 -> args0 }),
                visibilityLevel = javaType.visibilityLevel(),
                webUrl = javaType.webUrl(),
                wikiAccessLevel = javaType.wikiAccessLevel(),
                wikiEnabled = javaType.wikiEnabled(),
            )
    }
}
