@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property authorEmail The email of the author.
 * @property authorName The name of the author.
 * @property authoredDate The date which the commit was authored (format: yyyy-MM-ddTHH:mm:ssZ).
 * @property committedDate The date at which the commit was pushed (format: yyyy-MM-ddTHH:mm:ssZ).
 * @property committerEmail The email of the user that committed.
 * @property committerName The name of the user that committed.
 * @property id The unique id assigned to the commit by Gitlab.
 * @property message The commit message
 * @property parentIds The id of the parents of the commit
 * @property shortId The short id assigned to the commit by Gitlab.
 * @property title The title of the commit
 */
public data class GetProjectTagCommit(
    public val authorEmail: String,
    public val authorName: String,
    public val authoredDate: String,
    public val committedDate: String,
    public val committerEmail: String,
    public val committerName: String,
    public val id: String,
    public val message: String,
    public val parentIds: List<String>,
    public val shortId: String,
    public val title: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectTagCommit): GetProjectTagCommit = GetProjectTagCommit(
            authorEmail = javaType.authorEmail(),
            authorName = javaType.authorName(),
            authoredDate = javaType.authoredDate(),
            committedDate = javaType.committedDate(),
            committerEmail = javaType.committerEmail(),
            committerName = javaType.committerName(),
            id = javaType.id(),
            message = javaType.message(),
            parentIds = javaType.parentIds().map({ args0 -> args0 }),
            shortId = javaType.shortId(),
            title = javaType.title(),
        )
    }
}
