@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getProjectTag.
 * @property commits The commit associated with the tag.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property message The message of the annotated tag.
 * @property name The name of a tag.
 * @property project The ID or URL-encoded path of the project owned by the authenticated user.
 * @property protected Bool, true if tag has tag protection.
 * @property releases The release associated with the tag.
 * @property target The unique id assigned to the commit by Gitlab.
 */
public data class GetProjectTagResult(
    public val commits: List<GetProjectTagCommit>,
    public val id: String,
    public val message: String,
    public val name: String,
    public val project: String,
    public val `protected`: Boolean,
    public val releases: List<GetProjectTagRelease>,
    public val target: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectTagResult): GetProjectTagResult = GetProjectTagResult(
            commits = javaType.commits().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetProjectTagCommit.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            message = javaType.message(),
            name = javaType.name(),
            project = javaType.project(),
            `protected` = javaType.protected_(),
            releases = javaType.releases().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetProjectTagRelease.Companion.toKotlin(args0)
                })
            }),
            target = javaType.target(),
        )
    }
}
