@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getProjectTags.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property orderBy Return tags ordered by `name` or `updated` fields. Default is `updated`.
 * @property project The ID or URL-encoded path of the project owned by the authenticated user.
 * @property search Return list of tags matching the search criteria. You can use `^term` and `term$` to find tags that begin and end with `term` respectively. No other regular expressions are supported.
 * @property sort Return tags sorted in `asc` or `desc` order. Default is `desc`.
 * @property tags List of repository tags from a project.
 */
public data class GetProjectTagsResult(
    public val id: String,
    public val orderBy: String? = null,
    public val project: String,
    public val search: String? = null,
    public val sort: String? = null,
    public val tags: List<GetProjectTagsTag>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectTagsResult): GetProjectTagsResult = GetProjectTagsResult(
            id = javaType.id(),
            orderBy = javaType.orderBy().map({ args0 -> args0 }).orElse(null),
            project = javaType.project(),
            search = javaType.search().map({ args0 -> args0 }).orElse(null),
            sort = javaType.sort().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetProjectTagsTag.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
