@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property commits The commit associated with the tag.
 * @property message The message of the annotated tag.
 * @property name The name of a tag.
 * @property protected Bool, true if tag has tag protection.
 * @property releases The release associated with the tag.
 * @property target The unique id assigned to the commit by Gitlab.
 */
public data class GetProjectTagsTag(
    public val commits: List<GetProjectTagsTagCommit>,
    public val message: String,
    public val name: String,
    public val `protected`: Boolean,
    public val releases: List<GetProjectTagsTagRelease>,
    public val target: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectTagsTag): GetProjectTagsTag =
            GetProjectTagsTag(
                commits = javaType.commits().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.gitlab.kotlin.outputs.GetProjectTagsTagCommit.Companion.toKotlin(args0)
                    })
                }),
                message = javaType.message(),
                name = javaType.name(),
                `protected` = javaType.protected_(),
                releases = javaType.releases().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.gitlab.kotlin.outputs.GetProjectTagsTagRelease.Companion.toKotlin(args0)
                    })
                }),
                target = javaType.target(),
            )
    }
}
