@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getProjectVariables.
 * @property environmentScope The environment scope of the variable. Defaults to all environment (`*`).
 * @property id The provider-assigned unique ID for this managed resource.
 * @property project The name or id of the project.
 * @property variables The list of variables returned by the search
 */
public data class GetProjectVariablesResult(
    public val environmentScope: String? = null,
    public val id: String,
    public val project: String,
    public val variables: List<GetProjectVariablesVariable>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectVariablesResult): GetProjectVariablesResult = GetProjectVariablesResult(
            environmentScope = javaType.environmentScope().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            project = javaType.project(),
            variables = javaType.variables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetProjectVariablesVariable.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
