@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property _links Links for the project.
 * @property allowMergeOnSkippedPipeline Whether allow_merge_on_skipped_pipeline is enabled for the project.
 * @property analyticsAccessLevel Set the analytics access level. Valid values are `disabled`, `private`, `enabled`.
 * @property approvalsBeforeMerge The numbers of approvals needed in a merge requests.
 * @property archived Whether the project is archived.
 * @property autoCancelPendingPipelines Auto-cancel pending pipelines. This isn’t a boolean, but enabled/disabled.
 * @property autoDevopsDeployStrategy Auto Deploy strategy. Valid values are `continuous`, `manual`, `timed_incremental`.
 * @property autoDevopsEnabled Enable Auto DevOps for this project.
 * @property autocloseReferencedIssues Set whether auto-closing referenced issues on default branch.
 * @property avatarUrl The avatar url of the project.
 * @property buildCoverageRegex Build coverage regex for the project.
 * @property buildGitStrategy The Git strategy. Defaults to fetch.
 * @property buildTimeout The maximum amount of time, in seconds, that a job can run.
 * @property buildsAccessLevel Set the builds access level. Valid values are `disabled`, `private`, `enabled`.
 * @property ciConfigPath CI config file path for the project.
 * @property ciDefaultGitDepth Default number of revisions for shallow cloning.
 * @property ciForwardDeploymentEnabled When a new deployment job starts, skip older deployment jobs that are still pending.
 * @property ciRestrictPipelineCancellationRole The role required to cancel a pipeline or job. Introduced in GitLab 16.8. Premium and Ultimate only. Valid values are `developer`, `maintainer`, `no one`
 * @property containerExpirationPolicies Set the image cleanup policy for this project. **Note**: this field is sometimes named `container_expiration_policy_attributes` in the GitLab Upstream API.
 * @property containerRegistryAccessLevel Set visibility of container registry, for this project. Valid values are `disabled`, `private`, `enabled`.
 * @property containerRegistryEnabled Whether the container registry is enabled for the project.
 * @property createdAt Creation time for the project.
 * @property creatorId Creator ID for the project.
 * @property customAttributes Custom attributes for the project.
 * @property defaultBranch The default branch name of the project.
 * @property description The description of the project.
 * @property emailsEnabled Enable email notifications.
 * @property emptyRepo Whether the project is empty.
 * @property environmentsAccessLevel Set the environments access level. Valid values are `disabled`, `private`, `enabled`.
 * @property externalAuthorizationClassificationLabel The classification label for the project.
 * @property featureFlagsAccessLevel Set the feature flags access level. Valid values are `disabled`, `private`, `enabled`.
 * @property forkedFromProjects Present if the project is a fork. Contains information about the upstream project.
 * @property forkingAccessLevel Set the forking access level. Valid values are `disabled`, `private`, `enabled`.
 * @property forksCount The number of forks of the project.
 * @property groupRunnersEnabled Whether group runners are enabled for the project.
 * @property httpUrlToRepo The HTTP clone URL of the project.
 * @property id The ID of the project.
 * @property importError The import error, if it exists, for the project.
 * @property importStatus The import status of the project.
 * @property importUrl URL the project was imported from.
 * @property infrastructureAccessLevel Set the infrastructure access level. Valid values are `disabled`, `private`, `enabled`.
 * @property issuesAccessLevel Set the issues access level. Valid values are `disabled`, `private`, `enabled`.
 * @property issuesEnabled Whether issues are enabled for the project.
 * @property jobsEnabled Whether pipelines are enabled for the project.
 * @property keepLatestArtifact Disable or enable the ability to keep the latest artifact for this project.
 * @property lastActivityAt Last activirty time for the project.
 * @property lfsEnabled Whether LFS (large file storage) is enabled for the project.
 * @property mergeCommitTemplate Template used to create merge commit message in merge requests. (Introduced in GitLab 14.5.)
 * @property mergeMethod Merge method for the project.
 * @property mergePipelinesEnabled Enable or disable merge pipelines.
 * @property mergeRequestsAccessLevel Set the merge requests access level. Valid values are `disabled`, `private`, `enabled`.
 * @property mergeRequestsEnabled Whether merge requests are enabled for the project.
 * @property mergeTrainsEnabled Enable or disable merge trains.
 * @property mirror Whether the pull mirroring is enabled for the project.
 * @property mirrorOverwritesDivergedBranches Whether mirror_overwrites_diverged_branches is enabled for the project.
 * @property mirrorTriggerBuilds Whether pull mirroring triggers builds for the project.
 * @property mirrorUserId The mirror user ID for the project.
 * @property monitorAccessLevel Set the monitor access level. Valid values are `disabled`, `private`, `enabled`.
 * @property name The name of the project.
 * @property nameWithNamespace In `group / subgroup / project` or `user / project` format.
 * @property namespaces Namespace of the project (parent group/s).
 * @property onlyAllowMergeIfAllDiscussionsAreResolved Whether only_allow_merge_if_all_discussions_are_resolved is enabled for the project.
 * @property onlyAllowMergeIfPipelineSucceeds Whether only_allow_merge_if_pipeline_succeeds is enabled for the project.
 * @property onlyMirrorProtectedBranches Whether only_mirror_protected_branches is enabled for the project.
 * @property openIssuesCount The number of open issies for the project.
 * @property owners
 * @property packagesEnabled Whether packages are enabled for the project.
 * @property path The path of the project.
 * @property pathWithNamespace In `group/subgroup/project` or `user/project` format.
 * @property permissions Permissions for the project.
 * @property publicBuilds Whether public builds are enabled for the project.
 * @property readmeUrl The remote url of the project.
 * @property releasesAccessLevel Set the releases access level. Valid values are `disabled`, `private`, `enabled`.
 * @property repositoryAccessLevel Set the repository access level. Valid values are `disabled`, `private`, `enabled`.
 * @property repositoryStorage Which storage shard the repository is on. (administrator only)
 * @property requestAccessEnabled Whether requesting access is enabled for the project.
 * @property requirementsAccessLevel Set the requirements access level. Valid values are `disabled`, `private`, `enabled`.
 * @property resolveOutdatedDiffDiscussions Whether resolve_outdated_diff_discussions is enabled for the project
 * @property restrictUserDefinedVariables Allow only users with the Maintainer role to pass user-defined variables when triggering a pipeline.
 * @property runnersToken The runners token for the project.
 * @property securityAndComplianceAccessLevel Set the security and compliance access level. Valid values are `disabled`, `private`, `enabled`.
 * @property sharedRunnersEnabled Whether shared runners are enabled for the project.
 * @property sharedWithGroups Groups the the project is shared with.
 * @property snippetsAccessLevel Set the snippets access level. Valid values are `disabled`, `private`, `enabled`.
 * @property snippetsEnabled Whether snippets are enabled for the project.
 * @property squashCommitTemplate Template used to create squash commit message in merge requests. (Introduced in GitLab 14.6.)
 * @property sshUrlToRepo The SSH clone URL of the project.
 * @property starCount The number of stars on the project.
 * @property statistics Statistics for the project.
 * @property suggestionCommitMessage The commit message used to apply merge request suggestions.
 * @property tagLists A set of the project topics (formerly called "project tags").
 * @property topics The list of topics for the project.
 * @property visibility The visibility of the project.
 * @property webUrl The web url of the project.
 * @property wikiAccessLevel Set the wiki access level. Valid values are `disabled`, `private`, `enabled`.
 * @property wikiEnabled Whether wiki is enabled for the project.
 */
public data class GetProjectsProject(
    public val _links: Map<String, String>,
    public val allowMergeOnSkippedPipeline: Boolean,
    public val analyticsAccessLevel: String,
    public val approvalsBeforeMerge: Int,
    public val archived: Boolean,
    public val autoCancelPendingPipelines: String,
    public val autoDevopsDeployStrategy: String,
    public val autoDevopsEnabled: Boolean,
    public val autocloseReferencedIssues: Boolean,
    public val avatarUrl: String,
    public val buildCoverageRegex: String,
    public val buildGitStrategy: String,
    public val buildTimeout: Int,
    public val buildsAccessLevel: String,
    public val ciConfigPath: String,
    public val ciDefaultGitDepth: Int,
    public val ciForwardDeploymentEnabled: Boolean,
    public val ciRestrictPipelineCancellationRole: String,
    public val containerExpirationPolicies: List<GetProjectsProjectContainerExpirationPolicy>,
    public val containerRegistryAccessLevel: String,
    public val containerRegistryEnabled: Boolean,
    public val createdAt: String,
    public val creatorId: Int,
    public val customAttributes: List<Map<String, String>>,
    public val defaultBranch: String,
    public val description: String,
    public val emailsEnabled: Boolean,
    public val emptyRepo: Boolean,
    public val environmentsAccessLevel: String,
    public val externalAuthorizationClassificationLabel: String,
    public val featureFlagsAccessLevel: String,
    public val forkedFromProjects: List<GetProjectsProjectForkedFromProject>,
    public val forkingAccessLevel: String,
    public val forksCount: Int,
    public val groupRunnersEnabled: Boolean,
    public val httpUrlToRepo: String,
    public val id: Int,
    public val importError: String,
    public val importStatus: String,
    public val importUrl: String,
    public val infrastructureAccessLevel: String,
    public val issuesAccessLevel: String,
    public val issuesEnabled: Boolean,
    public val jobsEnabled: Boolean,
    public val keepLatestArtifact: Boolean,
    public val lastActivityAt: String,
    public val lfsEnabled: Boolean,
    public val mergeCommitTemplate: String,
    public val mergeMethod: String,
    public val mergePipelinesEnabled: Boolean,
    public val mergeRequestsAccessLevel: String,
    public val mergeRequestsEnabled: Boolean,
    public val mergeTrainsEnabled: Boolean,
    public val mirror: Boolean,
    public val mirrorOverwritesDivergedBranches: Boolean,
    public val mirrorTriggerBuilds: Boolean,
    public val mirrorUserId: Int,
    public val monitorAccessLevel: String,
    public val name: String,
    public val nameWithNamespace: String,
    public val namespaces: List<GetProjectsProjectNamespace>,
    public val onlyAllowMergeIfAllDiscussionsAreResolved: Boolean,
    public val onlyAllowMergeIfPipelineSucceeds: Boolean,
    public val onlyMirrorProtectedBranches: Boolean,
    public val openIssuesCount: Int,
    public val owners: List<GetProjectsProjectOwner>,
    public val packagesEnabled: Boolean,
    public val path: String,
    public val pathWithNamespace: String,
    public val permissions: List<GetProjectsProjectPermission>,
    public val publicBuilds: Boolean,
    public val readmeUrl: String,
    public val releasesAccessLevel: String,
    public val repositoryAccessLevel: String,
    public val repositoryStorage: String,
    public val requestAccessEnabled: Boolean,
    public val requirementsAccessLevel: String,
    public val resolveOutdatedDiffDiscussions: Boolean,
    public val restrictUserDefinedVariables: Boolean,
    public val runnersToken: String,
    public val securityAndComplianceAccessLevel: String,
    public val sharedRunnersEnabled: Boolean,
    public val sharedWithGroups: List<GetProjectsProjectSharedWithGroup>,
    public val snippetsAccessLevel: String,
    public val snippetsEnabled: Boolean,
    public val squashCommitTemplate: String,
    public val sshUrlToRepo: String,
    public val starCount: Int,
    public val statistics: Map<String, Int>,
    public val suggestionCommitMessage: String,
    public val tagLists: List<String>,
    public val topics: List<String>,
    public val visibility: String,
    public val webUrl: String,
    public val wikiAccessLevel: String,
    public val wikiEnabled: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectsProject): GetProjectsProject = GetProjectsProject(
            _links = javaType._links().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            allowMergeOnSkippedPipeline = javaType.allowMergeOnSkippedPipeline(),
            analyticsAccessLevel = javaType.analyticsAccessLevel(),
            approvalsBeforeMerge = javaType.approvalsBeforeMerge(),
            archived = javaType.archived(),
            autoCancelPendingPipelines = javaType.autoCancelPendingPipelines(),
            autoDevopsDeployStrategy = javaType.autoDevopsDeployStrategy(),
            autoDevopsEnabled = javaType.autoDevopsEnabled(),
            autocloseReferencedIssues = javaType.autocloseReferencedIssues(),
            avatarUrl = javaType.avatarUrl(),
            buildCoverageRegex = javaType.buildCoverageRegex(),
            buildGitStrategy = javaType.buildGitStrategy(),
            buildTimeout = javaType.buildTimeout(),
            buildsAccessLevel = javaType.buildsAccessLevel(),
            ciConfigPath = javaType.ciConfigPath(),
            ciDefaultGitDepth = javaType.ciDefaultGitDepth(),
            ciForwardDeploymentEnabled = javaType.ciForwardDeploymentEnabled(),
            ciRestrictPipelineCancellationRole = javaType.ciRestrictPipelineCancellationRole(),
            containerExpirationPolicies = javaType.containerExpirationPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetProjectsProjectContainerExpirationPolicy.Companion.toKotlin(args0)
                })
            }),
            containerRegistryAccessLevel = javaType.containerRegistryAccessLevel(),
            containerRegistryEnabled = javaType.containerRegistryEnabled(),
            createdAt = javaType.createdAt(),
            creatorId = javaType.creatorId(),
            customAttributes = javaType.customAttributes().map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
            defaultBranch = javaType.defaultBranch(),
            description = javaType.description(),
            emailsEnabled = javaType.emailsEnabled(),
            emptyRepo = javaType.emptyRepo(),
            environmentsAccessLevel = javaType.environmentsAccessLevel(),
            externalAuthorizationClassificationLabel = javaType.externalAuthorizationClassificationLabel(),
            featureFlagsAccessLevel = javaType.featureFlagsAccessLevel(),
            forkedFromProjects = javaType.forkedFromProjects().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetProjectsProjectForkedFromProject.Companion.toKotlin(args0)
                })
            }),
            forkingAccessLevel = javaType.forkingAccessLevel(),
            forksCount = javaType.forksCount(),
            groupRunnersEnabled = javaType.groupRunnersEnabled(),
            httpUrlToRepo = javaType.httpUrlToRepo(),
            id = javaType.id(),
            importError = javaType.importError(),
            importStatus = javaType.importStatus(),
            importUrl = javaType.importUrl(),
            infrastructureAccessLevel = javaType.infrastructureAccessLevel(),
            issuesAccessLevel = javaType.issuesAccessLevel(),
            issuesEnabled = javaType.issuesEnabled(),
            jobsEnabled = javaType.jobsEnabled(),
            keepLatestArtifact = javaType.keepLatestArtifact(),
            lastActivityAt = javaType.lastActivityAt(),
            lfsEnabled = javaType.lfsEnabled(),
            mergeCommitTemplate = javaType.mergeCommitTemplate(),
            mergeMethod = javaType.mergeMethod(),
            mergePipelinesEnabled = javaType.mergePipelinesEnabled(),
            mergeRequestsAccessLevel = javaType.mergeRequestsAccessLevel(),
            mergeRequestsEnabled = javaType.mergeRequestsEnabled(),
            mergeTrainsEnabled = javaType.mergeTrainsEnabled(),
            mirror = javaType.mirror(),
            mirrorOverwritesDivergedBranches = javaType.mirrorOverwritesDivergedBranches(),
            mirrorTriggerBuilds = javaType.mirrorTriggerBuilds(),
            mirrorUserId = javaType.mirrorUserId(),
            monitorAccessLevel = javaType.monitorAccessLevel(),
            name = javaType.name(),
            nameWithNamespace = javaType.nameWithNamespace(),
            namespaces = javaType.namespaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetProjectsProjectNamespace.Companion.toKotlin(args0)
                })
            }),
            onlyAllowMergeIfAllDiscussionsAreResolved = javaType.onlyAllowMergeIfAllDiscussionsAreResolved(),
            onlyAllowMergeIfPipelineSucceeds = javaType.onlyAllowMergeIfPipelineSucceeds(),
            onlyMirrorProtectedBranches = javaType.onlyMirrorProtectedBranches(),
            openIssuesCount = javaType.openIssuesCount(),
            owners = javaType.owners().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetProjectsProjectOwner.Companion.toKotlin(args0)
                })
            }),
            packagesEnabled = javaType.packagesEnabled(),
            path = javaType.path(),
            pathWithNamespace = javaType.pathWithNamespace(),
            permissions = javaType.permissions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetProjectsProjectPermission.Companion.toKotlin(args0)
                })
            }),
            publicBuilds = javaType.publicBuilds(),
            readmeUrl = javaType.readmeUrl(),
            releasesAccessLevel = javaType.releasesAccessLevel(),
            repositoryAccessLevel = javaType.repositoryAccessLevel(),
            repositoryStorage = javaType.repositoryStorage(),
            requestAccessEnabled = javaType.requestAccessEnabled(),
            requirementsAccessLevel = javaType.requirementsAccessLevel(),
            resolveOutdatedDiffDiscussions = javaType.resolveOutdatedDiffDiscussions(),
            restrictUserDefinedVariables = javaType.restrictUserDefinedVariables(),
            runnersToken = javaType.runnersToken(),
            securityAndComplianceAccessLevel = javaType.securityAndComplianceAccessLevel(),
            sharedRunnersEnabled = javaType.sharedRunnersEnabled(),
            sharedWithGroups = javaType.sharedWithGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetProjectsProjectSharedWithGroup.Companion.toKotlin(args0)
                })
            }),
            snippetsAccessLevel = javaType.snippetsAccessLevel(),
            snippetsEnabled = javaType.snippetsEnabled(),
            squashCommitTemplate = javaType.squashCommitTemplate(),
            sshUrlToRepo = javaType.sshUrlToRepo(),
            starCount = javaType.starCount(),
            statistics = javaType.statistics().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            suggestionCommitMessage = javaType.suggestionCommitMessage(),
            tagLists = javaType.tagLists().map({ args0 -> args0 }),
            topics = javaType.topics().map({ args0 -> args0 }),
            visibility = javaType.visibility(),
            webUrl = javaType.webUrl(),
            wikiAccessLevel = javaType.wikiAccessLevel(),
            wikiEnabled = javaType.wikiEnabled(),
        )
    }
}
