@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property httpUrlToRepo The HTTP clone URL of the upstream project.
 * @property id The ID of the upstream project.
 * @property name The name of the upstream project.
 * @property nameWithNamespace In `group / subgroup / project` or `user / project` format.
 * @property path The path of the upstream project.
 * @property pathWithNamespace In `group/subgroup/project` or `user/project` format.
 * @property webUrl The web url of the upstream project.
 */
public data class GetProjectsProjectForkedFromProject(
    public val httpUrlToRepo: String,
    public val id: Int,
    public val name: String,
    public val nameWithNamespace: String,
    public val path: String,
    public val pathWithNamespace: String,
    public val webUrl: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectsProjectForkedFromProject): GetProjectsProjectForkedFromProject = GetProjectsProjectForkedFromProject(
            httpUrlToRepo = javaType.httpUrlToRepo(),
            id = javaType.id(),
            name = javaType.name(),
            nameWithNamespace = javaType.nameWithNamespace(),
            path = javaType.path(),
            pathWithNamespace = javaType.pathWithNamespace(),
            webUrl = javaType.webUrl(),
        )
    }
}
