@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property avatarUrl The avatar url of the owner.
 * @property id The ID of the owner.
 * @property name The name of the owner.
 * @property state The state of the owner.
 * @property username The username of the owner.
 * @property websiteUrl The website url of the owner.
 */
public data class GetProjectsProjectOwner(
    public val avatarUrl: String,
    public val id: Int,
    public val name: String,
    public val state: String,
    public val username: String,
    public val websiteUrl: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectsProjectOwner): GetProjectsProjectOwner = GetProjectsProjectOwner(
            avatarUrl = javaType.avatarUrl(),
            id = javaType.id(),
            name = javaType.name(),
            state = javaType.state(),
            username = javaType.username(),
            websiteUrl = javaType.websiteUrl(),
        )
    }
}
