@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property groupAccess Group access level.
 * @property projectAccess Project access level.
 */
public data class GetProjectsProjectPermission(
    public val groupAccess: Map<String, Int>,
    public val projectAccess: Map<String, Int>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectsProjectPermission): GetProjectsProjectPermission = GetProjectsProjectPermission(
            groupAccess = javaType.groupAccess().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            projectAccess = javaType.projectAccess().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
