@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getProjects.
 * @property archived Limit by archived status.
 * @property groupId The ID of the group owned by the authenticated user to look projects for within. Cannot be used with `min_access_level`, `with_programming_language` or `statistics`.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property includeSubgroups Include projects in subgroups of this group. Default is `false`. Needs `group_id`.
 * @property maxQueryablePages The maximum number of project results pages that may be queried. Prevents overloading your Gitlab instance in case of a misconfiguration.
 * @property membership Limit by projects that the current user is a member of.
 * @property minAccessLevel Limit to projects where current user has at least this access level, refer to the [official documentation](https://docs.gitlab.com/ee/api/members.html) for values. Cannot be used with `group_id`.
 * @property orderBy Return projects ordered ordered by: `id`, `name`, `path`, `created_at`, `updated_at`, `last_activity_at`, `similarity`, `repository_size`, `storage_size`, `packages_size`, `wiki_size`. Some values or only available in certain circumstances. See [upstream docs](https://docs.gitlab.com/ee/api/projects.html#list-all-projects) for details.
 * @property owned Limit by projects owned by the current user.
 * @property page The first page to begin the query on.
 * @property perPage The number of results to return per page.
 * @property projects A list containing the projects matching the supplied arguments
 * @property search Return list of authorized projects matching the search criteria.
 * @property simple Return only the ID, URL, name, and path of each project.
 * @property sort Return projects sorted in `asc` or `desc` order. Default is `desc`.
 * @property starred Limit by projects starred by the current user.
 * @property statistics Include project statistics. Cannot be used with `group_id`.
 * @property topics Limit by projects that have all of the given topics.
 * @property visibility Limit by visibility `public`, `internal`, or `private`.
 * @property withCustomAttributes Include custom attributes in response *(admins only)*.
 * @property withIssuesEnabled Limit by projects with issues feature enabled. Default is `false`.
 * @property withMergeRequestsEnabled Limit by projects with merge requests feature enabled. Default is `false`.
 * @property withProgrammingLanguage Limit by projects which use the given programming language. Cannot be used with `group_id`.
 * @property withShared Include projects shared to this group. Default is `true`. Needs `group_id`.
 */
public data class GetProjectsResult(
    public val archived: Boolean? = null,
    public val groupId: Int? = null,
    public val id: String,
    public val includeSubgroups: Boolean? = null,
    public val maxQueryablePages: Int? = null,
    public val membership: Boolean? = null,
    public val minAccessLevel: Int? = null,
    public val orderBy: String? = null,
    public val owned: Boolean? = null,
    public val page: Int? = null,
    public val perPage: Int? = null,
    public val projects: List<GetProjectsProject>,
    public val search: String? = null,
    public val simple: Boolean? = null,
    public val sort: String? = null,
    public val starred: Boolean? = null,
    public val statistics: Boolean? = null,
    public val topics: List<String>? = null,
    public val visibility: String? = null,
    public val withCustomAttributes: Boolean? = null,
    public val withIssuesEnabled: Boolean? = null,
    public val withMergeRequestsEnabled: Boolean? = null,
    public val withProgrammingLanguage: String? = null,
    public val withShared: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectsResult): GetProjectsResult =
            GetProjectsResult(
                archived = javaType.archived().map({ args0 -> args0 }).orElse(null),
                groupId = javaType.groupId().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                includeSubgroups = javaType.includeSubgroups().map({ args0 -> args0 }).orElse(null),
                maxQueryablePages = javaType.maxQueryablePages().map({ args0 -> args0 }).orElse(null),
                membership = javaType.membership().map({ args0 -> args0 }).orElse(null),
                minAccessLevel = javaType.minAccessLevel().map({ args0 -> args0 }).orElse(null),
                orderBy = javaType.orderBy().map({ args0 -> args0 }).orElse(null),
                owned = javaType.owned().map({ args0 -> args0 }).orElse(null),
                page = javaType.page().map({ args0 -> args0 }).orElse(null),
                perPage = javaType.perPage().map({ args0 -> args0 }).orElse(null),
                projects = javaType.projects().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.gitlab.kotlin.outputs.GetProjectsProject.Companion.toKotlin(args0)
                    })
                }),
                search = javaType.search().map({ args0 -> args0 }).orElse(null),
                simple = javaType.simple().map({ args0 -> args0 }).orElse(null),
                sort = javaType.sort().map({ args0 -> args0 }).orElse(null),
                starred = javaType.starred().map({ args0 -> args0 }).orElse(null),
                statistics = javaType.statistics().map({ args0 -> args0 }).orElse(null),
                topics = javaType.topics().map({ args0 -> args0 }),
                visibility = javaType.visibility().map({ args0 -> args0 }).orElse(null),
                withCustomAttributes = javaType.withCustomAttributes().map({ args0 -> args0 }).orElse(null),
                withIssuesEnabled = javaType.withIssuesEnabled().map({ args0 -> args0 }).orElse(null),
                withMergeRequestsEnabled = javaType.withMergeRequestsEnabled().map({ args0 -> args0 }).orElse(null),
                withProgrammingLanguage = javaType.withProgrammingLanguage().map({ args0 -> args0 }).orElse(null),
                withShared = javaType.withShared().map({ args0 -> args0 }).orElse(null),
            )
    }
}
