@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property count The number of assets for a release
 * @property links The links for a release
 * @property sources The sources for a release
 */
public data class GetReleaseAssets(
    public val count: Int,
    public val links: List<GetReleaseAssetsLink>? = null,
    public val sources: List<GetReleaseAssetsSource>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetReleaseAssets): GetReleaseAssets =
            GetReleaseAssets(
                count = javaType.count(),
                links = javaType.links().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.gitlab.kotlin.outputs.GetReleaseAssetsLink.Companion.toKotlin(args0)
                    })
                }),
                sources = javaType.sources().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.gitlab.kotlin.outputs.GetReleaseAssetsSource.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
