@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ID of the link
 * @property linkType The type of the link
 * @property name The name of the link
 * @property url The URL of the link
 */
public data class GetReleaseAssetsLink(
    public val id: Int,
    public val linkType: String,
    public val name: String,
    public val url: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetReleaseAssetsLink): GetReleaseAssetsLink = GetReleaseAssetsLink(
            id = javaType.id(),
            linkType = javaType.linkType(),
            name = javaType.name(),
            url = javaType.url(),
        )
    }
}
