@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getReleaseLink.
 * @property directAssetUrl Full path for a [Direct Asset link](https://docs.gitlab.com/ee/user/project/releases/index.html#permanent-links-to-release-assets).
 * @property external External or internal link.
 * @property filepath Relative path for a [Direct Asset link](https://docs.gitlab.com/ee/user/project/releases/index.html#permanent-links-to-release-assets).
 * @property id The provider-assigned unique ID for this managed resource.
 * @property linkId The ID of the link.
 * @property linkType The type of the link. Valid values are `other`, `runbook`, `image`, `package`. Defaults to other.
 * @property name The name of the link. Link names must be unique within the release.
 * @property project The ID or [URL-encoded path of the project](https://docs.gitlab.com/ee/api/index.html#namespaced-path-encoding).
 * @property tagName The tag associated with the Release.
 * @property url The URL of the link. Link URLs must be unique within the release.
 */
public data class GetReleaseLinkResult(
    public val directAssetUrl: String,
    public val `external`: Boolean,
    public val filepath: String,
    public val id: String,
    public val linkId: Int,
    public val linkType: String,
    public val name: String,
    public val project: String,
    public val tagName: String,
    public val url: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetReleaseLinkResult): GetReleaseLinkResult = GetReleaseLinkResult(
            directAssetUrl = javaType.directAssetUrl(),
            `external` = javaType.`external`(),
            filepath = javaType.filepath(),
            id = javaType.id(),
            linkId = javaType.linkId(),
            linkType = javaType.linkType(),
            name = javaType.name(),
            project = javaType.project(),
            tagName = javaType.tagName(),
            url = javaType.url(),
        )
    }
}
