@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property directAssetUrl Full path for a [Direct Asset link](https://docs.gitlab.com/ee/user/project/releases/index.html#permanent-links-to-release-assets).
 * @property external External or internal link.
 * @property filepath Relative path for a [Direct Asset link](https://docs.gitlab.com/ee/user/project/releases/index.html#permanent-links-to-release-assets).
 * @property linkId The ID of the link.
 * @property linkType The type of the link. Valid values are `other`, `runbook`, `image`, `package`. Defaults to other.
 * @property name The name of the link. Link names must be unique within the release.
 * @property project The ID or [URL-encoded path of the project](https://docs.gitlab.com/ee/api/index.html#namespaced-path-encoding).
 * @property tagName The tag associated with the Release.
 * @property url The URL of the link. Link URLs must be unique within the release.
 */
public data class GetReleaseLinksReleaseLink(
    public val directAssetUrl: String,
    public val `external`: Boolean,
    public val filepath: String,
    public val linkId: Int,
    public val linkType: String,
    public val name: String,
    public val project: String,
    public val tagName: String,
    public val url: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetReleaseLinksReleaseLink): GetReleaseLinksReleaseLink = GetReleaseLinksReleaseLink(
            directAssetUrl = javaType.directAssetUrl(),
            `external` = javaType.`external`(),
            filepath = javaType.filepath(),
            linkId = javaType.linkId(),
            linkType = javaType.linkType(),
            name = javaType.name(),
            project = javaType.project(),
            tagName = javaType.tagName(),
            url = javaType.url(),
        )
    }
}
