@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getReleaseLinks.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property project The ID or full path to the project.
 * @property releaseLinks List of release links
 * @property tagName The tag associated with the Release.
 */
public data class GetReleaseLinksResult(
    public val id: String,
    public val project: String,
    public val releaseLinks: List<GetReleaseLinksReleaseLink>,
    public val tagName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetReleaseLinksResult): GetReleaseLinksResult = GetReleaseLinksResult(
            id = javaType.id(),
            project = javaType.project(),
            releaseLinks = javaType.releaseLinks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetReleaseLinksReleaseLink.Companion.toKotlin(args0)
                })
            }),
            tagName = javaType.tagName(),
        )
    }
}
