@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getRelease.
 * @property assets The assets for a release
 * @property createdAt The date the release was created.
 * @property description An HTML rendered description of the release.
 * @property id
 * @property name The name of the release.
 * @property projectId The ID or URL-encoded path of the project.
 * @property releasedAt The date the release was created.
 * @property tagName The Git tag the release is associated with.
 */
public data class GetReleaseResult(
    public val assets: GetReleaseAssets? = null,
    public val createdAt: String,
    public val description: String,
    public val id: String,
    public val name: String,
    public val projectId: String,
    public val releasedAt: String,
    public val tagName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetReleaseResult): GetReleaseResult =
            GetReleaseResult(
                assets = javaType.assets().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.gitlab.kotlin.outputs.GetReleaseAssets.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                createdAt = javaType.createdAt(),
                description = javaType.description(),
                id = javaType.id(),
                name = javaType.name(),
                projectId = javaType.projectId(),
                releasedAt = javaType.releasedAt(),
                tagName = javaType.tagName(),
            )
    }
}
