@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getRepositoryFile.
 * @property blobId The blob id.
 * @property commitId The commit id.
 * @property content File content.
 * @property contentSha256 File content sha256 digest.
 * @property encoding The file content encoding.
 * @property executeFilemode Enables or disables the execute flag on the file. **Note**: requires GitLab 14.10 or newer.
 * @property fileName The filename.
 * @property filePath The full path of the file. It must be relative to the root of the project without a leading slash `/` or `./`.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property lastCommitId The last known commit id.
 * @property project The name or ID of the project.
 * @property ref The name of branch, tag or commit.
 * @property size The file size.
 */
public data class GetRepositoryFileResult(
    public val blobId: String,
    public val commitId: String,
    public val content: String,
    public val contentSha256: String,
    public val encoding: String,
    public val executeFilemode: Boolean,
    public val fileName: String,
    public val filePath: String,
    public val id: String,
    public val lastCommitId: String,
    public val project: String,
    public val ref: String,
    public val size: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetRepositoryFileResult): GetRepositoryFileResult = GetRepositoryFileResult(
            blobId = javaType.blobId(),
            commitId = javaType.commitId(),
            content = javaType.content(),
            contentSha256 = javaType.contentSha256(),
            encoding = javaType.encoding(),
            executeFilemode = javaType.executeFilemode(),
            fileName = javaType.fileName(),
            filePath = javaType.filePath(),
            id = javaType.id(),
            lastCommitId = javaType.lastCommitId(),
            project = javaType.project(),
            ref = javaType.ref(),
            size = javaType.size(),
        )
    }
}
