@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRepositoryTree.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property path The path inside repository. Used to get content of subdirectories.
 * @property project The ID or full path of the project owned by the authenticated user.
 * @property recursive Boolean value used to get a recursive tree (false by default).
 * @property ref The name of a repository branch or tag.
 * @property trees The list of files/directories returned by the search
 */
public data class GetRepositoryTreeResult(
    public val id: String,
    public val path: String? = null,
    public val project: String,
    public val recursive: Boolean? = null,
    public val ref: String,
    public val trees: List<GetRepositoryTreeTree>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetRepositoryTreeResult): GetRepositoryTreeResult = GetRepositoryTreeResult(
            id = javaType.id(),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            project = javaType.project(),
            recursive = javaType.recursive().map({ args0 -> args0 }).orElse(null),
            ref = javaType.ref(),
            trees = javaType.trees().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetRepositoryTreeTree.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
