@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The SHA-1 hash of the tree or blob in the repository.
 * @property mode Unix access mode of the file in the repository.
 * @property name Name of the blob or tree in the repository
 * @property path Path of the object inside of the repository.
 * @property type Type of object in the repository. Can be either type tree or of type blob
 */
public data class GetRepositoryTreeTree(
    public val id: String,
    public val mode: String,
    public val name: String,
    public val path: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetRepositoryTreeTree): GetRepositoryTreeTree = GetRepositoryTreeTree(
            id = javaType.id(),
            mode = javaType.mode(),
            name = javaType.name(),
            path = javaType.path(),
            type = javaType.type(),
        )
    }
}
