@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getUser.
 * @property avatarUrl The avatar URL of the user.
 * @property bio The bio of the user.
 * @property canCreateGroup Whether the user can create groups.
 * @property canCreateProject Whether the user can create projects.
 * @property colorSchemeId User's color scheme ID.
 * @property createdAt Date the user was created at.
 * @property currentSignInAt Current user's sign-in date.
 * @property email The public email address of the user. **Note**: before GitLab 14.8 the lookup was based on the users primary email address.
 * @property externUid The external UID of the user.
 * @property external Whether the user is external.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property isAdmin Whether the user is an admin.
 * @property isBot Whether the user is a bot.
 * @property lastSignInAt Last user's sign-in date.
 * @property linkedin LinkedIn profile of the user.
 * @property location The location of the user.
 * @property name The name of the user.
 * @property namespaceId The ID of the user's namespace. Requires admin token to access this field. Available since GitLab 14.10.
 * @property note Admin notes for this user.
 * @property organization The organization of the user.
 * @property projectsLimit Number of projects the user can create.
 * @property skype Skype username of the user.
 * @property state Whether the user is active or blocked.
 * @property themeId User's theme ID.
 * @property twitter Twitter username of the user.
 * @property twoFactorEnabled Whether user's two-factor auth is enabled.
 * @property userId The ID of the user.
 * @property userProvider The UID provider of the user.
 * @property username The username of the user.
 * @property websiteUrl User's website URL.
 */
public data class GetUserResult(
    public val avatarUrl: String,
    public val bio: String,
    public val canCreateGroup: Boolean,
    public val canCreateProject: Boolean,
    public val colorSchemeId: Int,
    public val createdAt: String,
    public val currentSignInAt: String,
    public val email: String,
    public val externUid: String,
    public val `external`: Boolean,
    public val id: String,
    public val isAdmin: Boolean,
    public val isBot: Boolean,
    public val lastSignInAt: String,
    public val linkedin: String,
    public val location: String,
    public val name: String,
    public val namespaceId: Int,
    public val note: String,
    public val organization: String,
    public val projectsLimit: Int,
    public val skype: String,
    public val state: String,
    public val themeId: Int,
    public val twitter: String,
    public val twoFactorEnabled: Boolean,
    public val userId: Int,
    public val userProvider: String,
    public val username: String,
    public val websiteUrl: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetUserResult): GetUserResult =
            GetUserResult(
                avatarUrl = javaType.avatarUrl(),
                bio = javaType.bio(),
                canCreateGroup = javaType.canCreateGroup(),
                canCreateProject = javaType.canCreateProject(),
                colorSchemeId = javaType.colorSchemeId(),
                createdAt = javaType.createdAt(),
                currentSignInAt = javaType.currentSignInAt(),
                email = javaType.email(),
                externUid = javaType.externUid(),
                `external` = javaType.`external`(),
                id = javaType.id(),
                isAdmin = javaType.isAdmin(),
                isBot = javaType.isBot(),
                lastSignInAt = javaType.lastSignInAt(),
                linkedin = javaType.linkedin(),
                location = javaType.location(),
                name = javaType.name(),
                namespaceId = javaType.namespaceId(),
                note = javaType.note(),
                organization = javaType.organization(),
                projectsLimit = javaType.projectsLimit(),
                skype = javaType.skype(),
                state = javaType.state(),
                themeId = javaType.themeId(),
                twitter = javaType.twitter(),
                twoFactorEnabled = javaType.twoFactorEnabled(),
                userId = javaType.userId(),
                userProvider = javaType.userProvider(),
                username = javaType.username(),
                websiteUrl = javaType.websiteUrl(),
            )
    }
}
