@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createdAt The time when this key was created in GitLab.
 * @property expiresAt The expiration date of the SSH key in ISO 8601 format (YYYY-MM-DDTHH:MM:SSZ)
 * @property key The ssh key. The SSH key `comment` (trailing part) is optional and ignored for diffing, because GitLab overrides it with the username and GitLab hostname.
 * @property keyId The ID of the ssh key.
 * @property title The title of the ssh key.
 * @property userId The ID or username of the user. If this field is omitted, this resource manages a SSH key for the current user. Otherwise, this resource manages a SSH key for the specified user, and an admin token is required.
 */
public data class GetUserSshkeysKey(
    public val createdAt: String,
    public val expiresAt: String,
    public val key: String,
    public val keyId: Int,
    public val title: String,
    public val userId: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetUserSshkeysKey): GetUserSshkeysKey =
            GetUserSshkeysKey(
                createdAt = javaType.createdAt(),
                expiresAt = javaType.expiresAt(),
                key = javaType.key(),
                keyId = javaType.keyId(),
                title = javaType.title(),
                userId = javaType.userId(),
            )
    }
}
