@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getUserSshkeys.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property keys The user's keys.
 * @property userId ID of the user to get the SSH keys for.
 * @property username Username of the user to get the SSH keys for.
 */
public data class GetUserSshkeysResult(
    public val id: String,
    public val keys: List<GetUserSshkeysKey>,
    public val userId: Int,
    public val username: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetUserSshkeysResult): GetUserSshkeysResult = GetUserSshkeysResult(
            id = javaType.id(),
            keys = javaType.keys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetUserSshkeysKey.Companion.toKotlin(args0)
                })
            }),
            userId = javaType.userId(),
            username = javaType.username(),
        )
    }
}
