@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getUsers.
 * @property active Filter users that are active.
 * @property blocked Filter users that are blocked.
 * @property createdAfter Search for users created after a specific date. (Requires administrator privileges)
 * @property createdBefore Search for users created before a specific date. (Requires administrator privileges)
 * @property externProvider Lookup users by external provider. (Requires administrator privileges)
 * @property externUid Lookup users by external UID. (Requires administrator privileges)
 * @property id The provider-assigned unique ID for this managed resource.
 * @property orderBy Order the users' list by `id`, `name`, `username`, `created_at` or `updated_at`. (Requires administrator privileges)
 * @property search Search users by username, name or email.
 * @property sort Sort users' list in asc or desc order. (Requires administrator privileges)
 * @property users The list of users.
 */
public data class GetUsersResult(
    public val active: Boolean? = null,
    public val blocked: Boolean? = null,
    public val createdAfter: String? = null,
    public val createdBefore: String? = null,
    public val externProvider: String? = null,
    public val externUid: String? = null,
    public val id: String,
    public val orderBy: String? = null,
    public val search: String? = null,
    public val sort: String? = null,
    public val users: List<GetUsersUser>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetUsersResult): GetUsersResult =
            GetUsersResult(
                active = javaType.active().map({ args0 -> args0 }).orElse(null),
                blocked = javaType.blocked().map({ args0 -> args0 }).orElse(null),
                createdAfter = javaType.createdAfter().map({ args0 -> args0 }).orElse(null),
                createdBefore = javaType.createdBefore().map({ args0 -> args0 }).orElse(null),
                externProvider = javaType.externProvider().map({ args0 -> args0 }).orElse(null),
                externUid = javaType.externUid().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                orderBy = javaType.orderBy().map({ args0 -> args0 }).orElse(null),
                search = javaType.search().map({ args0 -> args0 }).orElse(null),
                sort = javaType.sort().map({ args0 -> args0 }).orElse(null),
                users = javaType.users().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.gitlab.kotlin.outputs.GetUsersUser.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
