@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allowForcePush Allow force push for all users with push access.
 * @property allowedToMerges An array of access levels allowed to merge. Valid values are: `developer`, `maintainer`.
 * @property allowedToPushes An array of access levels allowed to push. Valid values are: `developer`, `maintainer`.
 * @property developerCanInitialPush Allow developers to initial push.
 */
public data class GroupDefaultBranchProtectionDefaults(
    public val allowForcePush: Boolean? = null,
    public val allowedToMerges: List<String>? = null,
    public val allowedToPushes: List<String>? = null,
    public val developerCanInitialPush: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GroupDefaultBranchProtectionDefaults): GroupDefaultBranchProtectionDefaults = GroupDefaultBranchProtectionDefaults(
            allowForcePush = javaType.allowForcePush().map({ args0 -> args0 }).orElse(null),
            allowedToMerges = javaType.allowedToMerges().map({ args0 -> args0 }),
            allowedToPushes = javaType.allowedToPushes().map({ args0 -> args0 }),
            developerCanInitialPush = javaType.developerCanInitialPush().map({ args0 -> args0 }).orElse(null),
        )
    }
}
