@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property id The ID of the list.
 * @property labelId The ID of the label the list should be scoped to.
 * @property position The position of the list within the board. The position for the list is sed on the its position in the `lists` array.
 */
public data class GroupEpicBoardList(
    public val id: Int? = null,
    public val labelId: Int? = null,
    public val position: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GroupEpicBoardList): GroupEpicBoardList = GroupEpicBoardList(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            labelId = javaType.labelId().map({ args0 -> args0 }).orElse(null),
            position = javaType.position().map({ args0 -> args0 }).orElse(null),
        )
    }
}
