@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property id The ID of the list.
 * @property labelId The ID of the label the list should be scoped to.
 * @property position The explicit position of the list within the board, zero based.
 */
public data class GroupIssueBoardList(
    public val id: Int? = null,
    public val labelId: Int? = null,
    public val position: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GroupIssueBoardList): GroupIssueBoardList = GroupIssueBoardList(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            labelId = javaType.labelId().map({ args0 -> args0 }).orElse(null),
            position = javaType.position().map({ args0 -> args0 }).orElse(null),
        )
    }
}
