@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authorEmailRegex All commit author emails must match this regex, e.g. `@my-company.com$`.
 * @property branchNameRegex All branch names must match this regex, e.g. `(feature|hotfix)\/*`.
 * @property commitCommitterCheck Only commits pushed using verified emails are allowed.  **Note** This attribute is only supported in GitLab versions >= 16.4.
 * @property commitCommitterNameCheck Users can only push commits to this repository if the commit author name is consistent with their GitLab account name.
 * @property commitMessageNegativeRegex No commit message is allowed to match this regex, for example `ssh\:\/\/`.
 * @property commitMessageRegex All commit messages must match this regex, e.g. `Fixed \d+\..*`.
 * @property denyDeleteTag Deny deleting a tag.
 * @property fileNameRegex Filenames matching the regular expression provided in this attribute are not allowed, for example, `(jar|exe)$`.
 * @property maxFileSize Maximum file size (MB) allowed.
 * @property memberCheck Allows only GitLab users to author commits.
 * @property preventSecrets GitLab will reject any files that are likely to contain secrets.
 * @property rejectNonDcoCommits Reject commit when it’s not DCO certified.
 * @property rejectUnsignedCommits Only commits signed through GPG are allowed.  **Note** This attribute is only supported in GitLab versions >= 16.4.
 * */
 */
public data class GroupPushRules(
    public val authorEmailRegex: String? = null,
    public val branchNameRegex: String? = null,
    public val commitCommitterCheck: Boolean? = null,
    public val commitCommitterNameCheck: Boolean? = null,
    public val commitMessageNegativeRegex: String? = null,
    public val commitMessageRegex: String? = null,
    public val denyDeleteTag: Boolean? = null,
    public val fileNameRegex: String? = null,
    public val maxFileSize: Int? = null,
    public val memberCheck: Boolean? = null,
    public val preventSecrets: Boolean? = null,
    public val rejectNonDcoCommits: Boolean? = null,
    public val rejectUnsignedCommits: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GroupPushRules): GroupPushRules =
            GroupPushRules(
                authorEmailRegex = javaType.authorEmailRegex().map({ args0 -> args0 }).orElse(null),
                branchNameRegex = javaType.branchNameRegex().map({ args0 -> args0 }).orElse(null),
                commitCommitterCheck = javaType.commitCommitterCheck().map({ args0 -> args0 }).orElse(null),
                commitCommitterNameCheck = javaType.commitCommitterNameCheck().map({ args0 -> args0 }).orElse(null),
                commitMessageNegativeRegex = javaType.commitMessageNegativeRegex().map({ args0 ->
                    args0
                }).orElse(null),
                commitMessageRegex = javaType.commitMessageRegex().map({ args0 -> args0 }).orElse(null),
                denyDeleteTag = javaType.denyDeleteTag().map({ args0 -> args0 }).orElse(null),
                fileNameRegex = javaType.fileNameRegex().map({ args0 -> args0 }).orElse(null),
                maxFileSize = javaType.maxFileSize().map({ args0 -> args0 }).orElse(null),
                memberCheck = javaType.memberCheck().map({ args0 -> args0 }).orElse(null),
                preventSecrets = javaType.preventSecrets().map({ args0 -> args0 }).orElse(null),
                rejectNonDcoCommits = javaType.rejectNonDcoCommits().map({ args0 -> args0 }).orElse(null),
                rejectUnsignedCommits = javaType.rejectUnsignedCommits().map({ args0 -> args0 }).orElse(null),
            )
    }
}
