@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property expirationDays The duration (in days) the new token should be valid for.
 * @property rotateBeforeDays The duration (in days) before the expiration when the token should be rotated. As an example, if set to 7 days, the token will rotate 7 days before the expiration date, but only when `pulumi up` is run in that timeframe.
 */
public data class ProjectAccessTokenRotationConfiguration(
    public val expirationDays: Int,
    public val rotateBeforeDays: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.ProjectAccessTokenRotationConfiguration): ProjectAccessTokenRotationConfiguration = ProjectAccessTokenRotationConfiguration(
            expirationDays = javaType.expirationDays(),
            rotateBeforeDays = javaType.rotateBeforeDays(),
        )
    }
}
