@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cadence The cadence of the policy. Valid values are: `1d`, `7d`, `14d`, `1month`, `3month`.
 * @property enabled If true, the policy is enabled.
 * @property keepN The number of images to keep.
 * @property nameRegex The regular expression to match image names to delete.
 * @property nameRegexDelete The regular expression to match image names to delete.
 * @property nameRegexKeep The regular expression to match image names to keep.
 * @property nextRunAt The next time the policy will run.
 * @property olderThan The number of days to keep images.
 */
public data class ProjectContainerExpirationPolicy(
    public val cadence: String? = null,
    public val enabled: Boolean? = null,
    public val keepN: Int? = null,
    @Deprecated(
        message = """
  `name_regex` has been deprecated. Use `name_regex_delete` instead.
  """,
    )
    public val nameRegex: String? = null,
    public val nameRegexDelete: String? = null,
    public val nameRegexKeep: String? = null,
    public val nextRunAt: String? = null,
    public val olderThan: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.ProjectContainerExpirationPolicy): ProjectContainerExpirationPolicy = ProjectContainerExpirationPolicy(
            cadence = javaType.cadence().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            keepN = javaType.keepN().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            nameRegexDelete = javaType.nameRegexDelete().map({ args0 -> args0 }).orElse(null),
            nameRegexKeep = javaType.nameRegexKeep().map({ args0 -> args0 }).orElse(null),
            nextRunAt = javaType.nextRunAt().map({ args0 -> args0 }).orElse(null),
            olderThan = javaType.olderThan().map({ args0 -> args0 }).orElse(null),
        )
    }
}
