@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property assigneeId The ID of the assignee the list should be scoped to. Requires a GitLab EE license.
 * @property id The ID of the list
 * @property iterationId The ID of the iteration the list should be scoped to. Requires a GitLab EE license.
 * @property labelId The ID of the label the list should be scoped to. Requires a GitLab EE license.
 * @property milestoneId The ID of the milestone the list should be scoped to. Requires a GitLab EE license.
 * @property position The position of the list within the board. The position for the list is based on the its position in the `lists` array.
 */
public data class ProjectIssueBoardList(
    public val assigneeId: Int? = null,
    public val id: Int? = null,
    public val iterationId: Int? = null,
    public val labelId: Int? = null,
    public val milestoneId: Int? = null,
    public val position: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.ProjectIssueBoardList): ProjectIssueBoardList = ProjectIssueBoardList(
            assigneeId = javaType.assigneeId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            iterationId = javaType.iterationId().map({ args0 -> args0 }).orElse(null),
            labelId = javaType.labelId().map({ args0 -> args0 }).orElse(null),
            milestoneId = javaType.milestoneId().map({ args0 -> args0 }).orElse(null),
            position = javaType.position().map({ args0 -> args0 }).orElse(null),
        )
    }
}
