@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property completedCount The number of tasks that are completed.
 * @property count The number of tasks.
 */
public data class ProjectIssueTaskCompletionStatus(
    public val completedCount: Int? = null,
    public val count: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.ProjectIssueTaskCompletionStatus): ProjectIssueTaskCompletionStatus = ProjectIssueTaskCompletionStatus(
            completedCount = javaType.completedCount().map({ args0 -> args0 }).orElse(null),
            count = javaType.count().map({ args0 -> args0 }).orElse(null),
        )
    }
}
