@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessLevel Levels of access allowed to approve a deployment to this protected environment. Mutually exclusive with `user_id` and `group_id`. Valid values are `developer`, `maintainer`.
 * @property accessLevelDescription Readable description of level of access.
 * @property groupId The ID of the group allowed to approve a deployment to this protected environment. The project must be shared with the group. Mutually exclusive with `access_level` and `user_id`.
 * @property groupInheritanceType Group inheritance allows deploy access levels to take inherited group membership into account. Valid values are `0`, `1`. `0` => Direct group membership only, `1` => All inherited groups. Default: `0`
 * @property id The unique ID of the Approval Rules object.
 * @property requiredApprovals The number of approval required to allow deployment to this protected environment. This is mutually exclusive with user_id.
 * @property userId The ID of the user allowed to approve a deployment to this protected environment. The user must be a member of the project. Mutually exclusive with `access_level` and `group_id`.
 */
public data class ProjectProtectedEnvironmentApprovalRule(
    public val accessLevel: String? = null,
    public val accessLevelDescription: String? = null,
    public val groupId: Int? = null,
    public val groupInheritanceType: Int? = null,
    public val id: Int? = null,
    public val requiredApprovals: Int? = null,
    public val userId: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.ProjectProtectedEnvironmentApprovalRule): ProjectProtectedEnvironmentApprovalRule = ProjectProtectedEnvironmentApprovalRule(
            accessLevel = javaType.accessLevel().map({ args0 -> args0 }).orElse(null),
            accessLevelDescription = javaType.accessLevelDescription().map({ args0 -> args0 }).orElse(null),
            groupId = javaType.groupId().map({ args0 -> args0 }).orElse(null),
            groupInheritanceType = javaType.groupInheritanceType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            requiredApprovals = javaType.requiredApprovals().map({ args0 -> args0 }).orElse(null),
            userId = javaType.userId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
