@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description The description of release.
 * @property tagName The name of the tag.
 */
public data class ProjectTagRelease(
    public val description: String? = null,
    public val tagName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.ProjectTagRelease): ProjectTagRelease =
            ProjectTagRelease(
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                tagName = javaType.tagName().map({ args0 -> args0 }).orElse(null),
            )
    }
}
