/*
 * Decompiled with CFR 0.152.
 */
package scala.build.bloop;

import ch.epfl.scala.bsp4j.BuildClient;
import ch.epfl.scala.bsp4j.BuildClientCapabilities;
import ch.epfl.scala.bsp4j.InitializeBuildParams;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.build.bloop.BloopServer;
import scala.build.bloop.BloopThreads;
import scala.build.bloop.BuildServer;
import scala.build.bloop.bloop4j.BloopExtraBuildParams;
import scala.build.blooprifle.BloopRifle;
import scala.build.blooprifle.BloopRifle$;
import scala.build.blooprifle.BloopRifle$BloopNotRunning$;
import scala.build.blooprifle.BloopRifleConfig;
import scala.build.blooprifle.BloopRifleLogger;
import scala.build.blooprifle.BloopVersion;
import scala.build.blooprifle.BspConnection;
import scala.build.blooprifle.internal.Constants$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class BloopServer$ {
    public static final BloopServer$ MODULE$ = new BloopServer$();

    private BloopServer.ResolvedBloopParameters resolveBloopInfo(BloopRifle.BloopServerRuntimeInfo bloopInfo, BloopRifleConfig config) {
        BloopVersion bloopVersion;
        BloopRifleConfig.BloopVersionConstraint bloopVersionConstraint = config.retainedBloopVersion();
        if (bloopVersionConstraint instanceof BloopRifleConfig.AtLeast) {
            BloopRifleConfig.AtLeast atLeast = (BloopRifleConfig.AtLeast)bloopVersionConstraint;
            BloopVersion version = atLeast.version();
            Ordering ord = package$.MODULE$.Ordering().fromLessThan((Function2 & Serializable)(x$1, x$2) -> BoxesRunTime.boxToBoolean((boolean)x$1.isOlderThan(x$2)));
            bloopVersion = (BloopVersion)new .colon.colon((Object)bloopInfo.bloopVersion(), (List)new .colon.colon((Object)version, (List)Nil$.MODULE$)).max(ord);
        } else if (bloopVersionConstraint instanceof BloopRifleConfig.Strict) {
            BloopVersion version;
            BloopRifleConfig.Strict strict = (BloopRifleConfig.Strict)bloopVersionConstraint;
            bloopVersion = version = strict.version();
        } else {
            throw new MatchError((Object)bloopVersionConstraint);
        }
        BloopVersion bloopV = bloopVersion;
        int jvmV = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{bloopInfo.jvmVersion(), config.minimumBloopJvm()}))).max((Ordering)Ordering.Int$.MODULE$));
        String bloopInfoJava = ((Object)Paths.get(bloopInfo.javaHome(), "bin", "java")).toString();
        String expectedJava = jvmV >= bloopInfo.jvmVersion() ? config.javaPath() : bloopInfoJava;
        return new BloopServer.ResolvedBloopParameters(bloopV, jvmV, expectedJava);
    }

    private BloopRifle.BloopServerRuntimeInfo ensureBloopRunning(BloopRifleConfig config, ScheduledExecutorService startServerChecksPool, BloopRifleLogger logger) {
        Path workdir;
        block9: {
            boolean isOk;
            BloopServer.ResolvedBloopParameters resolvedBloopParameters;
            workdir = new File(".").getCanonicalFile().toPath();
            Either<BloopRifle.BloopAboutFailure, BloopRifle.BloopServerRuntimeInfo> bloopInfo = BloopRifle$.MODULE$.getCurrentBloopVersion(config, logger, workdir, startServerChecksPool);
            boolean isRunning = BloopRifle$.MODULE$.check(config, logger);
            Either<BloopRifle.BloopAboutFailure, BloopRifle.BloopServerRuntimeInfo> either = bloopInfo;
            if (either instanceof Left) {
                Left left = (Left)either;
                BloopRifle.BloopAboutFailure error = (BloopRifle.BloopAboutFailure)left.value();
                BloopRifle.BloopAboutFailure bloopAboutFailure = error;
                if (BloopRifle$BloopNotRunning$.MODULE$.equals(bloopAboutFailure)) {
                } else if (bloopAboutFailure instanceof BloopRifle.ParsingFailed) {
                    BloopRifle.ParsingFailed parsingFailed = (BloopRifle.ParsingFailed)bloopAboutFailure;
                    String bloopAboutOutput = parsingFailed.bloopAboutOutput();
                    logger.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Failed to parse output of 'bloop about':\n").append(bloopAboutOutput).toString());
                } else {
                    throw new MatchError((Object)bloopAboutFailure);
                }
                resolvedBloopParameters = new BloopServer.ResolvedBloopParameters(config.retainedBloopVersion().version(), config.minimumBloopJvm(), config.javaPath());
            } else if (either instanceof Right) {
                Right right = (Right)either;
                BloopRifle.BloopServerRuntimeInfo value = (BloopRifle.BloopServerRuntimeInfo)right.value();
                resolvedBloopParameters = this.resolveBloopInfo(value, config);
            } else {
                throw new MatchError(either);
            }
            BloopServer.ResolvedBloopParameters resolvedBloopParameters2 = resolvedBloopParameters;
            if (resolvedBloopParameters2 == null) {
                throw new MatchError((Object)resolvedBloopParameters2);
            }
            BloopVersion expectedBloopVersion = resolvedBloopParameters2.bloopVersion();
            int expectedBloopJvmRelease = resolvedBloopParameters2.jvmRelease();
            String javaPath = resolvedBloopParameters2.javaPath();
            Tuple3 tuple3 = new Tuple3((Object)expectedBloopVersion, (Object)BoxesRunTime.boxToInteger((int)expectedBloopJvmRelease), (Object)javaPath);
            BloopVersion expectedBloopVersion2 = (BloopVersion)tuple3._1();
            int expectedBloopJvmRelease2 = BoxesRunTime.unboxToInt((Object)tuple3._2());
            String javaPath2 = (String)tuple3._3();
            boolean bloopVersionIsOk = bloopInfo.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)BloopServer$.$anonfun$ensureBloopRunning$4(expectedBloopVersion2, x$4)));
            boolean bloopJvmIsOk = bloopInfo.exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)BloopServer$.$anonfun$ensureBloopRunning$5(expectedBloopJvmRelease2, x$5)));
            boolean bl = isOk = bloopVersionIsOk && bloopJvmIsOk;
            if (isOk) break block9;
            logger.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(21).append("Bloop daemon status: ").append(bloopInfo.fold((Function1 & Serializable)x$6 -> x$6.message(), (Function1 & Serializable)x$7 -> x$7.message())).toString());
            Object object = isRunning ? BoxesRunTime.boxToInteger((int)BloopServer$.exitBloop$1(config, workdir, logger)) : BoxedUnit.UNIT;
            BloopServer$.startBloop$1(expectedBloopVersion2.raw(), javaPath2, logger, config, startServerChecksPool);
        }
        return (BloopRifle.BloopServerRuntimeInfo)BloopRifle$.MODULE$.getCurrentBloopVersion(config, logger, workdir, startServerChecksPool).fold((Function1 & Serializable)e -> {
            throw new RuntimeException(new StringBuilder(36).append("Fatal error, could not spawn Bloop: ").append(e.message()).toString());
        }, (Function1 & Serializable)x -> (BloopRifle.BloopServerRuntimeInfo)Predef$.MODULE$.identity(x));
    }

    private Socket connect(BspConnection conn, FiniteDuration period, FiniteDuration timeout) {
        return this.create$1(System.currentTimeMillis() + timeout.toMillis(), conn, period, timeout);
    }

    public Tuple3<BspConnection, Socket, BloopRifle.BloopServerRuntimeInfo> bsp(BloopRifleConfig config, Path workspace, BloopThreads threads, BloopRifleLogger logger, FiniteDuration period, FiniteDuration timeout) {
        BloopRifle.BloopServerRuntimeInfo bloopInfo = this.ensureBloopRunning(config, threads.startServerChecks(), logger);
        logger.debug((Function0<String>)(Function0 & Serializable)() -> "Opening BSP connection with bloop");
        Files.createDirectories(workspace.resolve(".bloop"), new FileAttribute[0]);
        BspConnection conn = BloopRifle$.MODULE$.bsp(config, workspace, logger);
        logger.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("Bloop BSP connection waiting at ").append(conn.address()).toString());
        Socket socket = this.connect(conn, period, timeout);
        logger.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Connected to Bloop via BSP at ").append(conn.address()).toString());
        return new Tuple3((Object)conn, (Object)socket, (Object)bloopInfo);
    }

    public BloopServer buildServer(BloopRifleConfig config, String clientName, String clientVersion, Path workspace, Path classesDir, BuildClient buildClient, BloopThreads threads, BloopRifleLogger logger) {
        Tuple3<BspConnection, Socket, BloopRifle.BloopServerRuntimeInfo> tuple3 = this.bsp(config, workspace, threads, logger, config.period(), config.timeout());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        BspConnection conn = (BspConnection)tuple3._1();
        Socket socket = (Socket)tuple3._2();
        BloopRifle.BloopServerRuntimeInfo bloopInfo = (BloopRifle.BloopServerRuntimeInfo)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)conn, (Object)socket, (Object)bloopInfo);
        BspConnection conn2 = (BspConnection)tuple32._1();
        Socket socket2 = (Socket)tuple32._2();
        BloopRifle.BloopServerRuntimeInfo bloopInfo2 = (BloopRifle.BloopServerRuntimeInfo)tuple32._3();
        logger.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Connected to Bloop via BSP at ").append(conn2.address()).toString());
        Launcher launcher = new Launcher.Builder().setExecutorService(threads.jsonrpc()).setInput(socket2.getInputStream()).setOutput(socket2.getOutputStream()).setRemoteInterface(BuildServer.class).setLocalService((Object)buildClient).create();
        BuildServer server = (BuildServer)launcher.getRemoteProxy();
        buildClient.onConnectWithServer((ch.epfl.scala.bsp4j.BuildServer)server);
        Future f = launcher.startListening();
        InitializeBuildParams initParams = new InitializeBuildParams(clientName, clientVersion, Constants$.MODULE$.bspVersion(), workspace.toUri().toASCIIString(), new BuildClientCapabilities(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"scala", (List)new .colon.colon((Object)"java", (List)Nil$.MODULE$))).asJava()));
        BloopExtraBuildParams bloopExtraParams = new BloopExtraBuildParams();
        bloopExtraParams.setClientClassesRootDir(classesDir.toUri().toASCIIString());
        bloopExtraParams.setOwnsBuildFiles(Predef$.MODULE$.boolean2Boolean(true));
        initParams.setData((Object)bloopExtraParams);
        logger.debug((Function0<String>)(Function0 & Serializable)() -> "Sending buildInitialize BSP command to Bloop");
        try {
            server.buildInitialize(initParams).get(config.initTimeout().length(), config.initTimeout().unit());
        }
        catch (TimeoutException ex) {
            throw new Exception("Timeout while waiting for buildInitialize response", ex);
        }
        server.onBuildInitialized();
        return new BloopServer.BloopServerImpl(server, f, socket2, bloopInfo2);
    }

    public <T> T withBuildServer(BloopRifleConfig config, String clientName, String clientVersion, Path workspace, Path classesDir, BuildClient buildClient, BloopThreads threads, BloopRifleLogger logger, Function1<BloopServer, T> f) {
        Object object;
        BloopServer server = null;
        try {
            server = this.buildServer(config, clientName, clientVersion, workspace, classesDir, buildClient, threads, logger);
            object = f.apply((Object)server);
        }
        finally {
            if (server != null) {
                server.shutdown();
            }
        }
        return (T)object;
    }

    private static final void startBloop$1(String bloopVersion, String bloopJava, BloopRifleLogger logger$1, BloopRifleConfig config$1, ScheduledExecutorService startServerChecksPool$1) {
        logger$1.info((Function0<String>)(Function0 & Serializable)() -> "Starting compilation server");
        logger$1.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Starting Bloop ").append(bloopVersion).append(" at ").append(config$1.address().render()).append(" using JVM ").append(bloopJava).toString());
        scala.concurrent.Future<BoxedUnit> fut = BloopRifle$.MODULE$.startServer(config$1, startServerChecksPool$1, logger$1, bloopVersion, bloopJava);
        Await$.MODULE$.result(fut, (Duration)config$1.startCheckTimeout().$plus(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(30)).seconds()));
    }

    private static final int exitBloop$1(BloopRifleConfig config$1, Path workdir$1, BloopRifleLogger logger$1) {
        return BloopRifle$.MODULE$.exit(config$1, workdir$1, logger$1);
    }

    public static final /* synthetic */ boolean $anonfun$ensureBloopRunning$4(BloopVersion expectedBloopVersion$1, BloopRifle.BloopServerRuntimeInfo x$4) {
        BloopVersion bloopVersion = x$4.bloopVersion();
        BloopVersion bloopVersion2 = expectedBloopVersion$1;
        return !(bloopVersion != null ? !((Object)bloopVersion).equals(bloopVersion2) : bloopVersion2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$ensureBloopRunning$5(int expectedBloopJvmRelease$1, BloopRifle.BloopServerRuntimeInfo x$5) {
        return x$5.jvmVersion() == expectedBloopJvmRelease$1;
    }

    private final Socket create$1(long stopAt, BspConnection conn$1, FiniteDuration period$1, FiniteDuration timeout$1) {
        Left left;
        while (true) {
            Left maybeSocket;
            Left left2;
            try {
                left2 = package$.MODULE$.Right().apply((Object)conn$1.openSocket(period$1, timeout$1));
            }
            catch (ConnectException e) {
                left2 = package$.MODULE$.Left().apply((Object)e);
            }
            left = maybeSocket = left2;
            if (left instanceof Right) {
                Right right = (Right)left;
                Socket socket = (Socket)right.value();
                return socket;
            }
            if (!(left instanceof Left)) break;
            Left left3 = left;
            ConnectException e = (ConnectException)left3.value();
            if (System.currentTimeMillis() >= stopAt) {
                throw new IOException(new StringBuilder(17).append("Can't connect to ").append(conn$1.address()).toString(), e);
            }
            Thread.sleep(period$1.toMillis());
        }
        throw new MatchError((Object)left);
    }

    private BloopServer$() {
    }
}

