/*
 * Decompiled with CFR 0.152.
 */
package scala.build.bloop;

import ch.epfl.scala.bsp4j.BuildClient;
import ch.epfl.scala.bsp4j.BuildClientCapabilities;
import ch.epfl.scala.bsp4j.InitializeBuildParams;
import ch.epfl.scala.bsp4j.InitializeBuildResult;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.build.bloop.BloopServer;
import scala.build.bloop.BloopServer$BloopServerImpl$;
import scala.build.bloop.BloopServer$ResolvedBloopParameters$;
import scala.build.bloop.BloopThreads;
import scala.build.bloop.BuildServer;
import scala.build.bloop.bloop4j.BloopExtraBuildParams;
import scala.build.blooprifle.BloopRifle;
import scala.build.blooprifle.BloopRifle$;
import scala.build.blooprifle.BloopRifle$BloopNotRunning$;
import scala.build.blooprifle.BloopRifle$ParsingFailed$;
import scala.build.blooprifle.BloopRifleConfig;
import scala.build.blooprifle.BloopRifleConfig$AtLeast$;
import scala.build.blooprifle.BloopRifleConfig$Strict$;
import scala.build.blooprifle.BloopRifleLogger;
import scala.build.blooprifle.BloopVersion;
import scala.build.blooprifle.BspConnection;
import scala.build.blooprifle.internal.Constants$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.concurrent.Await$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class BloopServer$
implements Serializable {
    private static final BloopServer$BloopServerImpl$ BloopServerImpl;
    private static final BloopServer$ResolvedBloopParameters$ ResolvedBloopParameters;
    public static final BloopServer$ MODULE$;

    private BloopServer$() {
    }

    static {
        MODULE$ = new BloopServer$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BloopServer$.class);
    }

    private BloopServer.ResolvedBloopParameters resolveBloopInfo(BloopRifle.BloopServerRuntimeInfo bloopInfo, BloopRifleConfig config) {
        BloopVersion bloopVersion;
        BloopRifleConfig.BloopVersionConstraint bloopVersionConstraint = config.retainedBloopVersion();
        if (bloopVersionConstraint instanceof BloopRifleConfig.AtLeast) {
            BloopVersion bloopVersion2;
            BloopRifleConfig.AtLeast atLeast = BloopRifleConfig$AtLeast$.MODULE$.unapply((BloopRifleConfig.AtLeast)bloopVersionConstraint);
            BloopVersion version = bloopVersion2 = atLeast._1();
            Ordering ord = package$.MODULE$.Ordering().fromLessThan((Function2 & Serializable)(_$1, _$2) -> _$1.isOlderThan((BloopVersion)_$2));
            bloopVersion = (BloopVersion)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BloopVersion[]{bloopInfo.bloopVersion(), version})).max(ord);
        } else if (bloopVersionConstraint instanceof BloopRifleConfig.Strict) {
            BloopVersion bloopVersion3;
            BloopVersion version;
            BloopRifleConfig.Strict strict = BloopRifleConfig$Strict$.MODULE$.unapply((BloopRifleConfig.Strict)bloopVersionConstraint);
            bloopVersion = version = (bloopVersion3 = strict._1());
        } else {
            throw new MatchError((Object)bloopVersionConstraint);
        }
        BloopVersion bloopV = bloopVersion;
        int jvmV = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{bloopInfo.jvmVersion(), config.minimumBloopJvm()}))).max((Ordering)Ordering.Int$.MODULE$));
        String bloopInfoJava = Paths.get(bloopInfo.javaHome(), "bin", "java").toString();
        String expectedJava = jvmV >= bloopInfo.jvmVersion() ? config.javaPath() : bloopInfoJava;
        return BloopServer$ResolvedBloopParameters$.MODULE$.apply(bloopV, jvmV, expectedJava);
    }

    private BloopRifle.BloopServerRuntimeInfo ensureBloopRunning(BloopRifleConfig config, ScheduledExecutorService startServerChecksPool, BloopRifleLogger logger) {
        boolean isOk;
        BloopServer.ResolvedBloopParameters resolvedBloopParameters;
        Path workdir = new File(".").getCanonicalFile().toPath();
        Either<BloopRifle.BloopAboutFailure, BloopRifle.BloopServerRuntimeInfo> bloopInfo = BloopRifle$.MODULE$.getCurrentBloopVersion(config, logger, workdir, startServerChecksPool);
        boolean isRunning = BloopRifle$.MODULE$.check(config, logger);
        Either<BloopRifle.BloopAboutFailure, BloopRifle.BloopServerRuntimeInfo> either = bloopInfo;
        if (either instanceof Left) {
            BloopRifle.BloopAboutFailure error = (BloopRifle.BloopAboutFailure)((Left)either).value();
            BloopRifle.BloopAboutFailure bloopAboutFailure = error;
            if (!BloopRifle$BloopNotRunning$.MODULE$.equals(bloopAboutFailure)) {
                if (bloopAboutFailure instanceof BloopRifle.ParsingFailed) {
                    String string;
                    BloopRifle.ParsingFailed parsingFailed = BloopRifle$ParsingFailed$.MODULE$.unapply((BloopRifle.ParsingFailed)bloopAboutFailure);
                    String bloopAboutOutput = string = parsingFailed._1();
                    logger.info((Function0<String>)((Function0 & Serializable)() -> this.$anonfun$2(bloopAboutOutput)));
                } else {
                    throw new MatchError((Object)bloopAboutFailure);
                }
            }
            resolvedBloopParameters = BloopServer$ResolvedBloopParameters$.MODULE$.apply(config.retainedBloopVersion().version(), config.minimumBloopJvm(), config.javaPath());
        } else if (either instanceof Right) {
            BloopRifle.BloopServerRuntimeInfo value = (BloopRifle.BloopServerRuntimeInfo)((Right)either).value();
            resolvedBloopParameters = this.resolveBloopInfo(value, config);
        } else {
            throw new MatchError(either);
        }
        BloopServer.ResolvedBloopParameters resolvedBloopParameters2 = resolvedBloopParameters;
        if (resolvedBloopParameters2 == null) {
            throw new MatchError((Object)resolvedBloopParameters2);
        }
        BloopServer.ResolvedBloopParameters resolvedBloopParameters3 = BloopServer$ResolvedBloopParameters$.MODULE$.unapply(resolvedBloopParameters2);
        BloopVersion bloopVersion = resolvedBloopParameters3._1();
        int n = resolvedBloopParameters3._2();
        String string = resolvedBloopParameters3._3();
        BloopVersion expectedBloopVersion = bloopVersion;
        int expectedBloopJvmRelease = n;
        String javaPath = string;
        Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)expectedBloopVersion, (Object)BoxesRunTime.boxToInteger((int)expectedBloopJvmRelease), (Object)javaPath);
        BloopVersion expectedBloopVersion2 = (BloopVersion)tuple3._1();
        int expectedBloopJvmRelease2 = BoxesRunTime.unboxToInt((Object)tuple3._2());
        String javaPath2 = (String)tuple3._3();
        boolean bloopVersionIsOk = bloopInfo.exists((Function1 & Serializable)_$3 -> {
            BloopVersion bloopVersion = _$3.bloopVersion();
            BloopVersion bloopVersion2 = expectedBloopVersion2;
            return !(bloopVersion != null ? !((Object)bloopVersion).equals(bloopVersion2) : bloopVersion2 != null);
        });
        boolean bloopJvmIsOk = bloopInfo.exists((Function1 & Serializable)_$4 -> _$4.jvmVersion() == expectedBloopJvmRelease2);
        boolean bl = isOk = bloopVersionIsOk && bloopJvmIsOk;
        if (!isOk) {
            logger.debug((Function0<String>)((Function0 & Serializable)() -> this.ensureBloopRunning$$anonfun$1(bloopInfo)));
            if (isRunning) {
                this.exitBloop$1(config, logger, workdir);
            }
            this.startBloop$1(config, startServerChecksPool, logger, expectedBloopVersion2.raw(), javaPath2);
        }
        return (BloopRifle.BloopServerRuntimeInfo)BloopRifle$.MODULE$.getCurrentBloopVersion(config, logger, workdir, startServerChecksPool).fold((Function1 & Serializable)e -> {
            throw new RuntimeException(new StringBuilder(36).append("Fatal error, could not spawn Bloop: ").append(e.message()).toString());
        }, (Function1 & Serializable)x -> (BloopRifle.BloopServerRuntimeInfo)Predef$.MODULE$.identity(x));
    }

    private Socket connect(BspConnection conn, FiniteDuration period, FiniteDuration timeout) {
        return this.create$1(conn, period, timeout, System.currentTimeMillis() + timeout.toMillis());
    }

    public Tuple3<BspConnection, Socket, BloopRifle.BloopServerRuntimeInfo> bsp(BloopRifleConfig config, Path workspace, BloopThreads threads, BloopRifleLogger logger, FiniteDuration period, FiniteDuration timeout) {
        BloopRifle.BloopServerRuntimeInfo bloopInfo = this.ensureBloopRunning(config, threads.startServerChecks(), logger);
        logger.debug((Function0<String>)((Function0 & Serializable)this::bsp$$anonfun$1));
        Files.createDirectories(workspace.resolve(".bloop"), new FileAttribute[0]);
        BspConnection conn = BloopRifle$.MODULE$.bsp(config, workspace, logger);
        logger.debug((Function0<String>)((Function0 & Serializable)() -> this.bsp$$anonfun$2(conn)));
        Socket socket = this.connect(conn, period, timeout);
        logger.debug((Function0<String>)((Function0 & Serializable)() -> this.bsp$$anonfun$3(conn)));
        return Tuple3$.MODULE$.apply((Object)conn, (Object)socket, (Object)bloopInfo);
    }

    public BloopServer buildServer(BloopRifleConfig config, String clientName, String clientVersion, Path workspace, Path classesDir, BuildClient buildClient, BloopThreads threads, BloopRifleLogger logger) {
        Tuple3<BspConnection, Socket, BloopRifle.BloopServerRuntimeInfo> tuple3 = this.bsp(config, workspace, threads, logger, config.period(), config.timeout());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        BspConnection conn = (BspConnection)tuple3._1();
        Socket socket = (Socket)tuple3._2();
        BloopRifle.BloopServerRuntimeInfo bloopInfo = (BloopRifle.BloopServerRuntimeInfo)tuple3._3();
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)conn, (Object)socket, (Object)bloopInfo);
        BspConnection conn2 = (BspConnection)tuple32._1();
        Socket socket2 = (Socket)tuple32._2();
        BloopRifle.BloopServerRuntimeInfo bloopInfo2 = (BloopRifle.BloopServerRuntimeInfo)tuple32._3();
        logger.debug((Function0<String>)((Function0 & Serializable)() -> this.buildServer$$anonfun$1(conn2)));
        Launcher launcher = new Launcher.Builder().setExecutorService(threads.jsonrpc()).setInput(socket2.getInputStream()).setOutput(socket2.getOutputStream()).setRemoteInterface(BuildServer.class).setLocalService((Object)buildClient).create();
        BuildServer server = (BuildServer)launcher.getRemoteProxy();
        buildClient.onConnectWithServer((ch.epfl.scala.bsp4j.BuildServer)server);
        Future f = launcher.startListening();
        InitializeBuildParams initParams = new InitializeBuildParams(clientName, clientVersion, Constants$.MODULE$.bspVersion(), workspace.toUri().toASCIIString(), new BuildClientCapabilities(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"scala", "java"}))).asJava()));
        BloopExtraBuildParams bloopExtraParams = new BloopExtraBuildParams();
        bloopExtraParams.setClientClassesRootDir(classesDir.toUri().toASCIIString());
        bloopExtraParams.setOwnsBuildFiles(Predef$.MODULE$.boolean2Boolean(true));
        initParams.setData((Object)bloopExtraParams);
        logger.debug((Function0<String>)((Function0 & Serializable)this::buildServer$$anonfun$2));
        try {
            InitializeBuildResult cfr_ignored_0 = (InitializeBuildResult)server.buildInitialize(initParams).get(config.initTimeout().length(), config.initTimeout().unit());
        }
        catch (TimeoutException ex) {
            throw new Exception("Timeout while waiting for buildInitialize response", ex);
        }
        server.onBuildInitialized();
        return BloopServer$BloopServerImpl$.MODULE$.apply(server, f, socket2, bloopInfo2);
    }

    public <T> T withBuildServer(BloopRifleConfig config, String clientName, String clientVersion, Path workspace, Path classesDir, BuildClient buildClient, BloopThreads threads, BloopRifleLogger logger, Function1<BloopServer, T> f) {
        Object object;
        BloopServer server = null;
        try {
            server = this.buildServer(config, clientName, clientVersion, workspace, classesDir, buildClient, threads, logger);
            object = f.apply((Object)server);
        }
        finally {
            if (server != null) {
                server.shutdown();
            }
        }
        return (T)object;
    }

    private final String startBloop$1$$anonfun$1() {
        return "Starting compilation server";
    }

    private final String startBloop$1$$anonfun$2(BloopRifleConfig config$2, String bloopVersion$1, String bloopJava$1) {
        return new StringBuilder(30).append("Starting Bloop ").append(bloopVersion$1).append(" at ").append(config$2.address().render()).append(" using JVM ").append(bloopJava$1).toString();
    }

    private final void startBloop$1(BloopRifleConfig config$1, ScheduledExecutorService startServerChecksPool$1, BloopRifleLogger logger$1, String bloopVersion, String bloopJava) {
        logger$1.info((Function0<String>)((Function0 & Serializable)this::startBloop$1$$anonfun$1));
        logger$1.debug((Function0<String>)((Function0 & Serializable)() -> this.startBloop$1$$anonfun$2(config$1, bloopVersion, bloopJava)));
        scala.concurrent.Future<BoxedUnit> fut = BloopRifle$.MODULE$.startServer(config$1, startServerChecksPool$1, logger$1, bloopVersion, bloopJava);
        Await$.MODULE$.result(fut, (Duration)config$1.startCheckTimeout().$plus(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(30)).seconds()));
    }

    private final int exitBloop$1(BloopRifleConfig config$3, BloopRifleLogger logger$2, Path workdir$1) {
        return BloopRifle$.MODULE$.exit(config$3, workdir$1, logger$2);
    }

    private final String $anonfun$2(String bloopAboutOutput$1) {
        return new StringBuilder(41).append("Failed to parse output of 'bloop about':\n").append(bloopAboutOutput$1).toString();
    }

    private final String ensureBloopRunning$$anonfun$1(Either bloopInfo$1) {
        return new StringBuilder(21).append("Bloop daemon status: ").append(bloopInfo$1.fold((Function1 & Serializable)_$5 -> _$5.message(), (Function1 & Serializable)_$6 -> _$6.message())).toString();
    }

    private final Socket create$1(BspConnection conn$1, FiniteDuration period$1, FiniteDuration timeout$1, long stopAt) {
        Left left;
        while (true) {
            Left maybeSocket;
            Left left2;
            try {
                left2 = package$.MODULE$.Right().apply((Object)conn$1.openSocket(period$1, timeout$1));
            }
            catch (ConnectException e) {
                left2 = package$.MODULE$.Left().apply((Object)e);
            }
            left = maybeSocket = left2;
            if (left instanceof Right) {
                Socket socket = (Socket)((Right)left).value();
                return socket;
            }
            if (!(left instanceof Left)) break;
            ConnectException e = (ConnectException)left.value();
            if (System.currentTimeMillis() >= stopAt) {
                throw new IOException(new StringBuilder(17).append("Can't connect to ").append(conn$1.address()).toString(), e);
            }
            Thread.sleep(period$1.toMillis());
        }
        throw new MatchError((Object)left);
    }

    private final String bsp$$anonfun$1() {
        return "Opening BSP connection with bloop";
    }

    private final String bsp$$anonfun$2(BspConnection conn$2) {
        return new StringBuilder(32).append("Bloop BSP connection waiting at ").append(conn$2.address()).toString();
    }

    private final String bsp$$anonfun$3(BspConnection conn$3) {
        return new StringBuilder(30).append("Connected to Bloop via BSP at ").append(conn$3.address()).toString();
    }

    private final String buildServer$$anonfun$1(BspConnection conn$4) {
        return new StringBuilder(30).append("Connected to Bloop via BSP at ").append(conn$4.address()).toString();
    }

    private final String buildServer$$anonfun$2() {
        return "Sending buildInitialize BSP command to Bloop";
    }
}

