/*
 * Decompiled with CFR 0.152.
 */
package scala.build;

import ch.epfl.scala.bsp4j.BuildServer;
import ch.epfl.scala.bsp4j.Diagnostic;
import ch.epfl.scala.bsp4j.DiagnosticSeverity;
import ch.epfl.scala.bsp4j.DidChangeBuildTarget;
import ch.epfl.scala.bsp4j.LogMessageParams;
import ch.epfl.scala.bsp4j.MessageType;
import ch.epfl.scala.bsp4j.PublishDiagnosticsParams;
import ch.epfl.scala.bsp4j.Range;
import ch.epfl.scala.bsp4j.ShowMessageParams;
import ch.epfl.scala.bsp4j.StatusCode;
import ch.epfl.scala.bsp4j.TaskFinishParams;
import ch.epfl.scala.bsp4j.TaskProgressParams;
import ch.epfl.scala.bsp4j.TaskStartParams;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Paths;
import os.Path;
import os.Path$;
import os.PathConvertible;
import os.ReadablePath;
import os.read$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.build.BloopBuildClient;
import scala.build.ConsoleBloopBuildClient$;
import scala.build.GeneratedSource;
import scala.build.Logger;
import scala.build.Position;
import scala.build.errors.Severity;
import scala.build.options.Scope;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.util.Either;

public class ConsoleBloopBuildClient
implements BloopBuildClient {
    private final Logger logger;
    private final boolean keepDiagnostics;
    private final Map<Scope, Seq<GeneratedSource>> generatedSources;
    private Seq<String> projectParams;
    private boolean printedStart;
    private final ListBuffer<Tuple2<Either<String, Path>, Diagnostic>> diagnostics0;

    public static String diagnosticPrefix(DiagnosticSeverity diagnosticSeverity) {
        return ConsoleBloopBuildClient$.MODULE$.diagnosticPrefix(diagnosticSeverity);
    }

    public static String diagnosticPrefix(Severity severity) {
        return ConsoleBloopBuildClient$.MODULE$.diagnosticPrefix(severity);
    }

    public static void printFileDiagnostic(Logger logger, Either<String, Path> either, Diagnostic diagnostic) {
        ConsoleBloopBuildClient$.MODULE$.printFileDiagnostic(logger, either, diagnostic);
    }

    public static void printOtherDiagnostic(Logger logger, String string, Severity severity, Seq<Position> seq) {
        ConsoleBloopBuildClient$.MODULE$.printOtherDiagnostic(logger, string, severity, seq);
    }

    public static boolean $lessinit$greater$default$2() {
        return ConsoleBloopBuildClient$.MODULE$.$lessinit$greater$default$2();
    }

    public static Map<Scope, Seq<GeneratedSource>> $lessinit$greater$default$3() {
        return ConsoleBloopBuildClient$.MODULE$.$lessinit$greater$default$3();
    }

    public ConsoleBloopBuildClient(Logger logger, boolean keepDiagnostics, Map<Scope, Seq<GeneratedSource>> generatedSources) {
        this.logger = logger;
        this.keepDiagnostics = keepDiagnostics;
        this.generatedSources = generatedSources;
        this.projectParams = (Seq)package$.MODULE$.Seq().empty();
        this.printedStart = false;
        this.diagnostics0 = new ListBuffer();
    }

    private String projectNameSuffix() {
        if (this.projectParams.isEmpty()) {
            return "";
        }
        return new StringBuilder(3).append(" (").append(this.projectParams.mkString(", ")).append(")").toString();
    }

    private String projectName() {
        return new StringBuilder(7).append("project").append(this.projectNameSuffix()).toString();
    }

    @Override
    public void setGeneratedSources(Scope scope, Seq<GeneratedSource> newGeneratedSources) {
        this.generatedSources.update((Object)scope, newGeneratedSources);
    }

    @Override
    public void setProjectParams(Seq<String> newParams) {
        this.projectParams = newParams;
    }

    @Override
    public Option<Seq<Tuple2<Either<String, Path>, Diagnostic>>> diagnostics() {
        if (this.keepDiagnostics) {
            return Some$.MODULE$.apply((Object)this.diagnostics0.result());
        }
        return None$.MODULE$;
    }

    private Option<Tuple2<Either<String, Path>, Diagnostic>> postProcessDiagnostic(Path path, Diagnostic diag, scala.collection.immutable.Map<Path, Tuple2<Either<String, Path>, Object>> diagnosticMappings) {
        return diagnosticMappings.get((Object)path).collect((PartialFunction)new Serializable(diag){
            private final Diagnostic diag$1;
            {
                this.diag$1 = diag$4;
            }

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Either originalPath = (Either)tuple2._1();
                    int lineOffset = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    if (Predef$.MODULE$.Integer2int(this.diag$1.getRange().getStart().getLine()) + lineOffset >= 0 && Predef$.MODULE$.Integer2int(this.diag$1.getRange().getEnd().getLine()) + lineOffset >= 0) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Either originalPath = (Either)tuple2._1();
                    int lineOffset = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    if (Predef$.MODULE$.Integer2int(this.diag$1.getRange().getStart().getLine()) + lineOffset >= 0 && Predef$.MODULE$.Integer2int(this.diag$1.getRange().getEnd().getLine()) + lineOffset >= 0) {
                        ch.epfl.scala.bsp4j.Position start = new ch.epfl.scala.bsp4j.Position(Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(this.diag$1.getRange().getStart().getLine()) + lineOffset), this.diag$1.getRange().getStart().getCharacter());
                        ch.epfl.scala.bsp4j.Position end = new ch.epfl.scala.bsp4j.Position(Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(this.diag$1.getRange().getEnd().getLine()) + lineOffset), this.diag$1.getRange().getEnd().getCharacter());
                        Range range = new Range(start, end);
                        Diagnostic updatedDiag = new Diagnostic(range, this.diag$1.getMessage());
                        updatedDiag.setCode(this.diag$1.getCode());
                        updatedDiag.setRelatedInformation(this.diag$1.getRelatedInformation());
                        updatedDiag.setSeverity(this.diag$1.getSeverity());
                        updatedDiag.setSource(this.diag$1.getSource());
                        updatedDiag.setData(this.diag$1.getData());
                        return Tuple2$.MODULE$.apply((Object)originalPath, (Object)updatedDiag);
                    }
                }
                return function1.apply((Object)x);
            }
        });
    }

    public void onBuildPublishDiagnostics(PublishDiagnosticsParams params) {
        this.logger.debug(() -> ConsoleBloopBuildClient.onBuildPublishDiagnostics$$anonfun$1(params));
        CollectionConverters$.MODULE$.ListHasAsScala(params.getDiagnostics()).asScala().foreach((Function1)(JProcedure1 & Serializable)diag -> {
            scala.collection.immutable.Map diagnosticMappings = this.generatedSources.valuesIterator().flatMap((Function1 & Serializable)_$1 -> _$1.iterator()).map((Function1 & Serializable)source -> {
                int lineShift = -StringOps$.MODULE$.count$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(read$.MODULE$.apply((ReadablePath)source.generated())), source.topWrapperLen())), (Function1 & Serializable)_$2 -> ConsoleBloopBuildClient.$anonfun$3(BoxesRunTime.unboxToChar((Object)_$2)));
                return Tuple2$.MODULE$.apply((Object)source.generated(), (Object)Tuple2$.MODULE$.apply(source.reportingPath(), (Object)BoxesRunTime.boxToInteger((int)lineShift)));
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Path path = Path$.MODULE$.apply((Object)Paths.get(new URI(params.getTextDocument().getUri())).toAbsolutePath(), (PathConvertible)PathConvertible.NioPathConvertible$.MODULE$);
            Tuple2 tuple2 = (Tuple2)this.postProcessDiagnostic(path, (Diagnostic)diag, (scala.collection.immutable.Map<Path, Tuple2<Either<String, Path>, Object>>)diagnosticMappings).getOrElse(() -> ConsoleBloopBuildClient.$anonfun$4(diag, path));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Either updatedPath = (Either)tuple2._1();
            Diagnostic updatedDiag = (Diagnostic)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)updatedPath, (Object)updatedDiag);
            Either updatedPath2 = (Either)tuple22._1();
            Diagnostic updatedDiag2 = (Diagnostic)tuple22._2();
            if (this.keepDiagnostics) {
                Either either = (Either)Predef$.MODULE$.ArrowAssoc((Object)updatedPath2);
                this.diagnostics0.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)either, (Object)updatedDiag2));
            }
            ConsoleBloopBuildClient$.MODULE$.printFileDiagnostic(this.logger, (Either<String, Path>)updatedPath2, updatedDiag2);
        });
    }

    public void onBuildLogMessage(LogMessageParams params) {
        String string;
        this.logger.debug(() -> ConsoleBloopBuildClient.onBuildLogMessage$$anonfun$1(params));
        MessageType messageType = params.getType();
        MessageType messageType2 = MessageType.ERROR;
        MessageType messageType3 = messageType;
        if (!(messageType2 != null ? !messageType2.equals(messageType3) : messageType3 != null)) {
            string = "Error: ";
        } else {
            MessageType messageType4 = MessageType.WARNING;
            MessageType messageType5 = messageType;
            if (!(messageType4 != null ? !messageType4.equals(messageType5) : messageType5 != null)) {
                string = "Warning: ";
            } else {
                MessageType messageType6 = MessageType.INFORMATION;
                MessageType messageType7 = messageType;
                if (!(messageType6 != null ? !messageType6.equals(messageType7) : messageType7 != null)) {
                    string = "";
                } else {
                    MessageType messageType8 = MessageType.LOG;
                    MessageType messageType9 = messageType;
                    if (!(messageType8 != null ? !messageType8.equals(messageType9) : messageType9 != null)) {
                        string = "";
                    } else {
                        throw new MatchError((Object)messageType);
                    }
                }
            }
        }
        String prefix = string;
        this.logger.message(() -> ConsoleBloopBuildClient.onBuildLogMessage$$anonfun$2(params, prefix));
    }

    public void onBuildShowMessage(ShowMessageParams params) {
        this.logger.debug(() -> ConsoleBloopBuildClient.onBuildShowMessage$$anonfun$1(params));
    }

    public void onBuildTargetDidChange(DidChangeBuildTarget params) {
        this.logger.debug(() -> ConsoleBloopBuildClient.onBuildTargetDidChange$$anonfun$1(params));
    }

    public void onBuildTaskStart(TaskStartParams params) {
        this.logger.debug(() -> ConsoleBloopBuildClient.onBuildTaskStart$$anonfun$1(params));
        Option$.MODULE$.apply((Object)params.getMessage()).withFilter((Function1 & Serializable)msg -> !msg.contains(" no-op compilation")).foreach((Function1)(JProcedure1 & Serializable)msg -> {
            this.printedStart = true;
            String string = params.getDataKind();
            String string2 = "compile-task";
            String msg0 = !(string != null ? !string.equals(string2) : string2 != null) ? new StringBuilder(10).append("Compiling ").append(this.projectName()).toString() : msg;
            this.logger.message(() -> ConsoleBloopBuildClient.onBuildTaskStart$$anonfun$3$$anonfun$1(msg0));
        });
    }

    public void onBuildTaskProgress(TaskProgressParams params) {
        this.logger.debug(() -> ConsoleBloopBuildClient.onBuildTaskProgress$$anonfun$1(params));
    }

    public void onBuildTaskFinish(TaskFinishParams params) {
        this.logger.debug(() -> ConsoleBloopBuildClient.onBuildTaskFinish$$anonfun$1(params));
        if (this.printedStart) {
            Option$.MODULE$.apply((Object)params.getMessage()).foreach((Function1)(JProcedure1 & Serializable)msg -> {
                String string;
                String string2 = params.getDataKind();
                String string3 = "compile-report";
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    StatusCode statusCode = params.getStatus();
                    StatusCode statusCode2 = StatusCode.OK;
                    StatusCode statusCode3 = statusCode;
                    if (!(statusCode2 != null ? !statusCode2.equals(statusCode3) : statusCode3 != null)) {
                        string = new StringBuilder(9).append("Compiled ").append(this.projectName()).toString();
                    } else {
                        StatusCode statusCode4 = StatusCode.ERROR;
                        StatusCode statusCode5 = statusCode;
                        if (!(statusCode4 != null ? !statusCode4.equals(statusCode5) : statusCode5 != null)) {
                            string = new StringBuilder(16).append("Error compiling ").append(this.projectName()).toString();
                        } else {
                            StatusCode statusCode6 = StatusCode.CANCELLED;
                            StatusCode statusCode7 = statusCode;
                            if (statusCode6 != null ? !statusCode6.equals(statusCode7) : statusCode7 != null) throw new MatchError((Object)statusCode);
                            string = new StringBuilder(21).append("Compilation cancelled").append(this.projectNameSuffix()).toString();
                        }
                    }
                } else {
                    string = msg;
                }
                String msg0 = string;
                this.logger.message(() -> ConsoleBloopBuildClient.onBuildTaskFinish$$anonfun$2$$anonfun$1(msg0));
            });
            return;
        }
    }

    public void onConnectWithServer(BuildServer server) {
    }

    @Override
    public void clear() {
        this.generatedSources.clear();
        this.diagnostics0.clear();
        this.printedStart = false;
    }

    private static final String onBuildPublishDiagnostics$$anonfun$1(PublishDiagnosticsParams params$1) {
        return new StringBuilder(47).append("Received onBuildPublishDiagnostics from bloop: ").append(params$1).toString();
    }

    private static final /* synthetic */ boolean $anonfun$3(char _$2) {
        return _$2 == '\n';
    }

    private static final Tuple2 $anonfun$4(Diagnostic diag$2, Path path$1) {
        return Tuple2$.MODULE$.apply((Object)package$.MODULE$.Right().apply((Object)path$1), (Object)diag$2);
    }

    private static final String onBuildLogMessage$$anonfun$1(LogMessageParams params$3) {
        return new StringBuilder(39).append("Received onBuildLogMessage from bloop: ").append(params$3).toString();
    }

    private static final String onBuildLogMessage$$anonfun$2(LogMessageParams params$4, String prefix$1) {
        return new StringBuilder(0).append(prefix$1).append(params$4.getMessage()).toString();
    }

    private static final String onBuildShowMessage$$anonfun$1(ShowMessageParams params$5) {
        return new StringBuilder(40).append("Received onBuildShowMessage from bloop: ").append(params$5).toString();
    }

    private static final String onBuildTargetDidChange$$anonfun$1(DidChangeBuildTarget params$6) {
        return new StringBuilder(44).append("Received onBuildTargetDidChange from bloop: ").append(params$6).toString();
    }

    private static final String onBuildTaskStart$$anonfun$1(TaskStartParams params$7) {
        return new StringBuilder(38).append("Received onBuildTaskStart from bloop: ").append(params$7).toString();
    }

    private static final String onBuildTaskStart$$anonfun$3$$anonfun$1(String msg0$1) {
        return new StringBuilder(0).append(ConsoleBloopBuildClient$.scala$build$ConsoleBloopBuildClient$$$gray).append(msg0$1).append(ConsoleBloopBuildClient$.scala$build$ConsoleBloopBuildClient$$$reset).toString();
    }

    private static final String onBuildTaskProgress$$anonfun$1(TaskProgressParams params$9) {
        return new StringBuilder(41).append("Received onBuildTaskProgress from bloop: ").append(params$9).toString();
    }

    private static final String onBuildTaskFinish$$anonfun$1(TaskFinishParams params$10) {
        return new StringBuilder(39).append("Received onBuildTaskFinish from bloop: ").append(params$10).toString();
    }

    private static final String onBuildTaskFinish$$anonfun$2$$anonfun$1(String msg0$2) {
        return new StringBuilder(0).append(ConsoleBloopBuildClient$.scala$build$ConsoleBloopBuildClient$$$gray).append(msg0$2).append(ConsoleBloopBuildClient$.scala$build$ConsoleBloopBuildClient$$$reset).toString();
    }
}

