/*
 * Decompiled with CFR 0.152.
 */
package scala.build.bsp;

import ch.epfl.scala.bsp4j.BuildClient;
import ch.epfl.scala.bsp4j.BuildServer;
import ch.epfl.scala.bsp4j.BuildServerCapabilities;
import ch.epfl.scala.bsp4j.BuildTargetCapabilities;
import ch.epfl.scala.bsp4j.BuildTargetIdentifier;
import ch.epfl.scala.bsp4j.CleanCacheParams;
import ch.epfl.scala.bsp4j.CleanCacheResult;
import ch.epfl.scala.bsp4j.CompileParams;
import ch.epfl.scala.bsp4j.CompileProvider;
import ch.epfl.scala.bsp4j.CompileResult;
import ch.epfl.scala.bsp4j.DebugProvider;
import ch.epfl.scala.bsp4j.DebugSessionAddress;
import ch.epfl.scala.bsp4j.DebugSessionParams;
import ch.epfl.scala.bsp4j.DependencySourcesItem;
import ch.epfl.scala.bsp4j.DependencySourcesParams;
import ch.epfl.scala.bsp4j.DependencySourcesResult;
import ch.epfl.scala.bsp4j.InitializeBuildParams;
import ch.epfl.scala.bsp4j.InitializeBuildResult;
import ch.epfl.scala.bsp4j.LogMessageParams;
import ch.epfl.scala.bsp4j.MessageType;
import ch.epfl.scala.bsp4j.OutputPathItem;
import ch.epfl.scala.bsp4j.OutputPathItemKind;
import ch.epfl.scala.bsp4j.OutputPathsItem;
import ch.epfl.scala.bsp4j.OutputPathsParams;
import ch.epfl.scala.bsp4j.OutputPathsResult;
import ch.epfl.scala.bsp4j.ResourcesParams;
import ch.epfl.scala.bsp4j.ResourcesResult;
import ch.epfl.scala.bsp4j.RunParams;
import ch.epfl.scala.bsp4j.RunProvider;
import ch.epfl.scala.bsp4j.RunResult;
import ch.epfl.scala.bsp4j.SourcesParams;
import ch.epfl.scala.bsp4j.SourcesResult;
import ch.epfl.scala.bsp4j.TestParams;
import ch.epfl.scala.bsp4j.TestProvider;
import ch.epfl.scala.bsp4j.TestResult;
import ch.epfl.scala.bsp4j.WorkspaceBuildTargetsResult;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import os.Path;
import os.ReadablePath;
import os.read$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.build.GeneratedSource;
import scala.build.Logger;
import scala.build.bsp.BspServer$;
import scala.build.bsp.BuildServerForwardStubs;
import scala.build.bsp.HasGeneratedSources;
import scala.build.bsp.HasGeneratedSources$GeneratedSources$;
import scala.build.bsp.HasGeneratedSourcesImpl;
import scala.build.bsp.JavaBuildServerForwardStubs;
import scala.build.bsp.JvmBuildServerForwardStubs;
import scala.build.bsp.ScalaBuildServerForwardStubs;
import scala.build.bsp.ScalaScriptBuildServer;
import scala.build.bsp.WrappedSourceItem;
import scala.build.bsp.WrappedSourcesItem;
import scala.build.bsp.WrappedSourcesParams;
import scala.build.bsp.WrappedSourcesResult;
import scala.build.bsp.package$;
import scala.build.bsp.package$SourcesResultExt$;
import scala.build.bsp.package$WorkspaceBuildTargetsResultExt$;
import scala.build.internal.Constants$;
import scala.build.options.Scope;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Random$;

public class BspServer
implements BuildServerForwardStubs,
ScalaScriptBuildServer,
ScalaBuildServerForwardStubs,
JavaBuildServerForwardStubs,
JvmBuildServerForwardStubs,
HasGeneratedSourcesImpl {
    private Map projectNames;
    private Map generatedSources;
    private final BuildServer bloopServer;
    private final Function1<Function0<CompletableFuture<CompileResult>>, CompletableFuture<CompileResult>> compile;
    private final Logger logger;
    private Option<BuildClient> client;
    private volatile boolean intelliJ;
    private scala.collection.immutable.Seq<Path> extraDependencySources;
    private final List<String> supportedLanguages;
    private final Promise<BoxedUnit> shutdownPromise;

    public static boolean $lessinit$greater$default$4() {
        return BspServer$.MODULE$.$lessinit$greater$default$4();
    }

    public BspServer(BuildServer bloopServer, Function1<Function0<CompletableFuture<CompileResult>>, CompletableFuture<CompileResult>> compile, Logger logger, boolean presetIntelliJ) {
        this.bloopServer = bloopServer;
        this.compile = compile;
        this.logger = logger;
        HasGeneratedSourcesImpl.$init$(this);
        this.client = None$.MODULE$;
        this.intelliJ = presetIntelliJ;
        this.extraDependencySources = scala.package$.MODULE$.Nil();
        this.supportedLanguages = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"scala", "java", "scala-sc"}))).asJava();
        this.shutdownPromise = Promise$.MODULE$.apply();
        Statics.releaseFence();
    }

    public Map projectNames() {
        return this.projectNames;
    }

    public Map generatedSources() {
        return this.generatedSources;
    }

    @Override
    public void scala$build$bsp$HasGeneratedSourcesImpl$_setter_$projectNames_$eq(Map x$0) {
        this.projectNames = x$0;
    }

    @Override
    public void scala$build$bsp$HasGeneratedSourcesImpl$_setter_$generatedSources_$eq(Map x$0) {
        this.generatedSources = x$0;
    }

    public boolean isIntelliJ() {
        return this.intelliJ;
    }

    public Option<BuildClient> clientOpt() {
        return this.client;
    }

    public void onConnectWithClient(BuildClient client) {
        this.client = Some$.MODULE$.apply((Object)client);
    }

    public void setExtraDependencySources(scala.collection.immutable.Seq<Path> sourceJars) {
        this.extraDependencySources = sourceJars;
    }

    @Override
    public void onFatalError(Throwable throwable, String context) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        String message = new StringBuilder(60).append("Fatal error has occured within ").append(context).append(". Shutting down the server:\n ").append(sw.toString()).toString();
        System.err.println(message);
        this.client.foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.onBuildLogMessage(new LogMessageParams(MessageType.ERROR, message)));
        int timeout = Random$.MODULE$.nextInt(400);
        TimeUnit.MILLISECONDS.sleep(Int$.MODULE$.int2long(100 + timeout));
        throw scala.sys.package$.MODULE$.exit(1);
    }

    private void maybeUpdateProjectTargetUri(WorkspaceBuildTargetsResult res) {
        this.projectNames().iterator().withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                HasGeneratedSources.ProjectName n = (HasGeneratedSources.ProjectName)tuple2._2();
                return true;
            }
            return false;
        }).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                HasGeneratedSources.ProjectName n = (HasGeneratedSources.ProjectName)tuple2._2();
                return n.targetUriOpt().isEmpty();
            }
            throw new MatchError((Object)tuple2);
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                HasGeneratedSources.ProjectName n = (HasGeneratedSources.ProjectName)tuple2._2();
                CollectionConverters$.MODULE$.ListHasAsScala(res.getTargets()).asScala().iterator().find((Function1 & Serializable)_$2 -> {
                    String string = _$2.getDisplayName();
                    String string2 = n.name();
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }).foreach((Function1)(JProcedure1 & Serializable)target -> n.targetUriOpt_$eq((Option<String>)Some$.MODULE$.apply((Object)target.getId().getUri())));
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private void stripInvalidTargets(WorkspaceBuildTargetsResult params) {
        List updatedTargets = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(params.getTargets()).asScala().filter((Function1 & Serializable)target -> this.validTarget(target.getId()))).asJava();
        params.setTargets(updatedTargets);
    }

    private CleanCacheParams check(CleanCacheParams params) {
        Buffer invalidTargets = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(params.getTargets()).asScala().filter((Function1 & Serializable)_$3 -> !this.validTarget((BuildTargetIdentifier)_$3));
        invalidTargets.foreach((Function1)(JProcedure1 & Serializable)target -> this.logger.debug(() -> BspServer.check$$anonfun$1$$anonfun$1(target)));
        return params;
    }

    private CompileParams check(CompileParams params) {
        Buffer invalidTargets = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(params.getTargets()).asScala().filter((Function1 & Serializable)_$4 -> !this.validTarget((BuildTargetIdentifier)_$4));
        invalidTargets.foreach((Function1)(JProcedure1 & Serializable)target -> this.logger.debug(() -> BspServer.check$$anonfun$2$$anonfun$1(target)));
        return params;
    }

    private DependencySourcesParams check(DependencySourcesParams params) {
        Buffer invalidTargets = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(params.getTargets()).asScala().filter((Function1 & Serializable)_$5 -> !this.validTarget((BuildTargetIdentifier)_$5));
        invalidTargets.foreach((Function1)(JProcedure1 & Serializable)target -> this.logger.debug(() -> BspServer.check$$anonfun$3$$anonfun$1(target)));
        return params;
    }

    private ResourcesParams check(ResourcesParams params) {
        Buffer invalidTargets = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(params.getTargets()).asScala().filter((Function1 & Serializable)_$6 -> !this.validTarget((BuildTargetIdentifier)_$6));
        invalidTargets.foreach((Function1)(JProcedure1 & Serializable)target -> this.logger.debug(() -> BspServer.check$$anonfun$4$$anonfun$1(target)));
        return params;
    }

    private SourcesParams check(SourcesParams params) {
        Buffer invalidTargets = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(params.getTargets()).asScala().filter((Function1 & Serializable)_$7 -> !this.validTarget((BuildTargetIdentifier)_$7));
        invalidTargets.foreach((Function1)(JProcedure1 & Serializable)target -> this.logger.debug(() -> BspServer.check$$anonfun$5$$anonfun$1(target)));
        return params;
    }

    private TestParams check(TestParams params) {
        Buffer invalidTargets = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(params.getTargets()).asScala().filter((Function1 & Serializable)_$8 -> !this.validTarget((BuildTargetIdentifier)_$8));
        invalidTargets.foreach((Function1)(JProcedure1 & Serializable)target -> this.logger.debug(() -> BspServer.check$$anonfun$6$$anonfun$1(target)));
        return params;
    }

    private DebugSessionParams check(DebugSessionParams params) {
        Buffer invalidTargets = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(params.getTargets()).asScala().filter((Function1 & Serializable)_$9 -> !this.validTarget((BuildTargetIdentifier)_$9));
        invalidTargets.foreach((Function1)(JProcedure1 & Serializable)target -> this.logger.debug(() -> BspServer.check$$anonfun$7$$anonfun$1(target)));
        return params;
    }

    private OutputPathsParams check(OutputPathsParams params) {
        Buffer invalidTargets = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(params.getTargets()).asScala().filter((Function1 & Serializable)_$10 -> !this.validTarget((BuildTargetIdentifier)_$10));
        invalidTargets.foreach((Function1)(JProcedure1 & Serializable)target -> this.logger.debug(() -> BspServer.check$$anonfun$8$$anonfun$1(target)));
        return params;
    }

    private void mapGeneratedSources(SourcesResult res) {
        Vector gen = this.generatedSources().values().toVector();
        CollectionConverters$.MODULE$.ListHasAsScala(res.getItems()).asScala().withFilter((Function1 & Serializable)item -> this.validTarget(item.getTarget())).foreach((Function1)(JProcedure1 & Serializable)item -> CollectionConverters$.MODULE$.ListHasAsScala(item.getSources()).asScala().foreach((Function1)(JProcedure1 & Serializable)sourceItem -> gen.iterator().flatMap((Function1 & Serializable)_$11 -> _$11.uriMap().get((Object)sourceItem.getUri()).iterator()).take(1).foreach((Function1)(JProcedure1 & Serializable)genSource -> genSource.reportingPath().toOption().map((Function1 & Serializable)_$12 -> _$12.toNIO().toUri().toASCIIString()).foreach((Function1)(JProcedure1 & Serializable)updatedUri -> {
            sourceItem.setUri(updatedUri);
            sourceItem.setGenerated(Predef$.MODULE$.boolean2Boolean(false));
        }))));
    }

    @Override
    public BuildServer forwardTo() {
        return this.bloopServer;
    }

    private BuildServerCapabilities capabilities() {
        BuildServerCapabilities capabilities = new BuildServerCapabilities();
        capabilities.setCompileProvider(new CompileProvider(this.supportedLanguages));
        capabilities.setTestProvider(new TestProvider(this.supportedLanguages));
        capabilities.setRunProvider(new RunProvider(this.supportedLanguages));
        capabilities.setDebugProvider(new DebugProvider(this.supportedLanguages));
        capabilities.setInverseSourcesProvider(Predef$.MODULE$.boolean2Boolean(true));
        capabilities.setDependencySourcesProvider(Predef$.MODULE$.boolean2Boolean(true));
        capabilities.setResourcesProvider(Predef$.MODULE$.boolean2Boolean(true));
        capabilities.setBuildTargetChangedProvider(Predef$.MODULE$.boolean2Boolean(true));
        capabilities.setJvmRunEnvironmentProvider(Predef$.MODULE$.boolean2Boolean(true));
        capabilities.setJvmTestEnvironmentProvider(Predef$.MODULE$.boolean2Boolean(true));
        capabilities.setCanReload(Predef$.MODULE$.boolean2Boolean(true));
        capabilities.setDependencyModulesProvider(Predef$.MODULE$.boolean2Boolean(true));
        return capabilities;
    }

    public CompletableFuture<InitializeBuildResult> buildInitialize(InitializeBuildParams params) {
        boolean buildComesFromIntelliJ;
        InitializeBuildResult res = new InitializeBuildResult("scala-cli", Constants$.MODULE$.version(), scala.build.blooprifle.internal.Constants$.MODULE$.bspVersion(), this.capabilities());
        this.intelliJ = buildComesFromIntelliJ = params.getDisplayName().toLowerCase().contains("intellij");
        this.logger.debug(() -> BspServer.buildInitialize$$anonfun$1(buildComesFromIntelliJ));
        return CompletableFuture.completedFuture(res);
    }

    public void onBuildInitialized() {
    }

    @Override
    public CompletableFuture<CleanCacheResult> buildTargetCleanCache(CleanCacheParams params) {
        return BuildServerForwardStubs.buildTargetCleanCache$(this, this.check(params));
    }

    @Override
    public CompletableFuture<CompileResult> buildTargetCompile(CompileParams params) {
        return (CompletableFuture)this.compile.apply((Function0 & Serializable)() -> BuildServerForwardStubs.buildTargetCompile$(this, this.check(params)));
    }

    @Override
    public CompletableFuture<DependencySourcesResult> buildTargetDependencySources(DependencySourcesParams params) {
        return BuildServerForwardStubs.buildTargetDependencySources$(this, this.check(params)).thenApply(res -> {
            Buffer updatedItems = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(res.getItems()).asScala().map((Function1 & Serializable)x$1 -> {
                DependencySourcesItem dependencySourcesItem = x$1;
                DependencySourcesItem item = dependencySourcesItem;
                if (this.validTarget(item.getTarget())) {
                    Buffer updatedSources = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(item.getSources()).asScala().$plus$plus((IterableOnce)this.extraDependencySources.map((Function1 & Serializable)sourceJar -> sourceJar.toNIO().toUri().toASCIIString()));
                    return new DependencySourcesItem(item.getTarget(), CollectionConverters$.MODULE$.BufferHasAsJava(updatedSources).asJava());
                }
                DependencySourcesItem other = dependencySourcesItem;
                return other;
            });
            return new DependencySourcesResult(CollectionConverters$.MODULE$.BufferHasAsJava(updatedItems).asJava());
        });
    }

    @Override
    public CompletableFuture<ResourcesResult> buildTargetResources(ResourcesParams params) {
        return BuildServerForwardStubs.buildTargetResources$(this, this.check(params));
    }

    @Override
    public CompletableFuture<RunResult> buildTargetRun(RunParams params) {
        BuildTargetIdentifier target = params.getTarget();
        if (!this.validTarget(target)) {
            this.logger.debug(() -> this.buildTargetRun$$anonfun$1(target));
        }
        return BuildServerForwardStubs.buildTargetRun$(this, params);
    }

    @Override
    public CompletableFuture<SourcesResult> buildTargetSources(SourcesParams params) {
        return BuildServerForwardStubs.buildTargetSources$(this, this.check(params)).thenApply(res -> {
            SourcesResult res0 = package$SourcesResultExt$.MODULE$.duplicate$extension(package$.MODULE$.SourcesResultExt((SourcesResult)res));
            this.mapGeneratedSources(res0);
            return res0;
        });
    }

    @Override
    public CompletableFuture<TestResult> buildTargetTest(TestParams params) {
        return BuildServerForwardStubs.buildTargetTest$(this, this.check(params));
    }

    @Override
    public CompletableFuture<DebugSessionAddress> debugSessionStart(DebugSessionParams params) {
        return BuildServerForwardStubs.debugSessionStart$(this, this.check(params));
    }

    public CompletableFuture<OutputPathsResult> buildTargetOutputPaths(OutputPathsParams params) {
        this.check(params);
        Buffer targets = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(params.getTargets()).asScala().filter((Function1 & Serializable)id -> this.validTarget((BuildTargetIdentifier)id));
        Buffer outputPathsItem = (Buffer)((IterableOps)((IterableOps)targets.map((Function1 & Serializable)buildTargetId -> Tuple2$.MODULE$.apply(buildTargetId, (Object)this.targetWorkspaceDirOpt((BuildTargetIdentifier)buildTargetId)))).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Option option = (Option)tuple2._2();
                    BuildTargetIdentifier buildTargetId = (BuildTargetIdentifier)tuple2._1();
                    if (option instanceof Some) {
                        String targetUri = (String)((Some)option).value();
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Option option = (Option)tuple2._2();
                    BuildTargetIdentifier buildTargetId = (BuildTargetIdentifier)tuple2._1();
                    if (option instanceof Some) {
                        String targetUri = (String)((Some)option).value();
                        return Tuple2$.MODULE$.apply((Object)buildTargetId, (Object)targetUri);
                    }
                }
                return function1.apply((Object)x);
            }
        })).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                BuildTargetIdentifier buildTargetId = (BuildTargetIdentifier)tuple2._1();
                String targetUri = (String)tuple2._2();
                return new OutputPathsItem(buildTargetId, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OutputPathItem[]{new OutputPathItem(targetUri, OutputPathItemKind.DIRECTORY)}))).asJava());
            }
            throw new MatchError((Object)tuple2);
        });
        return CompletableFuture.completedFuture(new OutputPathsResult(CollectionConverters$.MODULE$.BufferHasAsJava(outputPathsItem).asJava()));
    }

    @Override
    public CompletableFuture<WorkspaceBuildTargetsResult> workspaceBuildTargets() {
        return BuildServerForwardStubs.workspaceBuildTargets$(this).thenApply(res -> {
            this.maybeUpdateProjectTargetUri((WorkspaceBuildTargetsResult)res);
            WorkspaceBuildTargetsResult res0 = package$WorkspaceBuildTargetsResultExt$.MODULE$.duplicate$extension(package$.MODULE$.WorkspaceBuildTargetsResultExt((WorkspaceBuildTargetsResult)res));
            this.stripInvalidTargets(res0);
            CollectionConverters$.MODULE$.ListHasAsScala(res0.getTargets()).asScala().foreach((Function1)(JProcedure1 & Serializable)target -> {
                BuildTargetCapabilities capabilities = target.getCapabilities();
                capabilities.setCanDebug(Predef$.MODULE$.boolean2Boolean(true));
                File baseDirectory = new File(new URI(target.getBaseDirectory()));
                if (this.isIntelliJ()) {
                    String string = baseDirectory.getName();
                    String string2 = Constants$.MODULE$.workspaceDirName();
                    if (!(string != null ? !string.equals(string2) : string2 != null) && baseDirectory.getParentFile() != null) {
                        String newBaseDirectory = baseDirectory.getParentFile().toPath().toUri().toASCIIString();
                        target.setBaseDirectory(newBaseDirectory);
                        return;
                    }
                }
            });
            return res0;
        });
    }

    public CompletableFuture<WrappedSourcesResult> buildTargetWrappedSources(WrappedSourcesParams params) {
        scala.collection.immutable.Seq sourceItems = (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Scope[]{Scope.Main$.MODULE$, Scope.Test$.MODULE$})).flatMap((Function1 & Serializable)_$14 -> Option$.MODULE$.option2Iterable(this.sourcesItemOpt$1((Scope)_$14)).toSeq());
        WrappedSourcesResult res = new WrappedSourcesResult(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)sourceItems).asJava());
        return CompletableFuture.completedFuture(res);
    }

    @Override
    public CompletableFuture<Object> buildShutdown() {
        if (!this.shutdownPromise.isCompleted()) {
            this.shutdownPromise.success((Object)BoxedUnit.UNIT);
        }
        return CompletableFuture.completedFuture(null);
    }

    public void onBuildExit() {
    }

    public Future<BoxedUnit> initiateShutdown() {
        return this.shutdownPromise.future();
    }

    private static final String check$$anonfun$1$$anonfun$1(BuildTargetIdentifier target$1) {
        return new StringBuilder(38).append("invalid target in CleanCache request: ").append(target$1).toString();
    }

    private static final String check$$anonfun$2$$anonfun$1(BuildTargetIdentifier target$2) {
        return new StringBuilder(35).append("invalid target in Compile request: ").append(target$2).toString();
    }

    private static final String check$$anonfun$3$$anonfun$1(BuildTargetIdentifier target$3) {
        return new StringBuilder(45).append("invalid target in DependencySources request: ").append(target$3).toString();
    }

    private static final String check$$anonfun$4$$anonfun$1(BuildTargetIdentifier target$4) {
        return new StringBuilder(37).append("invalid target in Resources request: ").append(target$4).toString();
    }

    private static final String check$$anonfun$5$$anonfun$1(BuildTargetIdentifier target$5) {
        return new StringBuilder(35).append("invalid target in Sources request: ").append(target$5).toString();
    }

    private static final String check$$anonfun$6$$anonfun$1(BuildTargetIdentifier target$6) {
        return new StringBuilder(32).append("invalid target in Test request: ").append(target$6).toString();
    }

    private static final String check$$anonfun$7$$anonfun$1(BuildTargetIdentifier target$7) {
        return new StringBuilder(32).append("invalid target in Test request: ").append(target$7).toString();
    }

    private static final String check$$anonfun$8$$anonfun$1(BuildTargetIdentifier target$8) {
        return new StringBuilder(50).append("invalid target in buildTargetOutputPaths request: ").append(target$8).toString();
    }

    private static final String buildInitialize$$anonfun$1(boolean buildComesFromIntelliJ$1) {
        return new StringBuilder(16).append("IntelliJ build: ").append(buildComesFromIntelliJ$1).toString();
    }

    private final String buildTargetRun$$anonfun$1(BuildTargetIdentifier target$9) {
        return new StringBuilder(47).append("Got invalid target in Run request: ").append(target$9.getUri()).append(" (expected ").append(this.targetScopeIdOpt((Scope)Scope.Main$.MODULE$).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).append(")").toString();
    }

    private static final HasGeneratedSources.GeneratedSources $anonfun$15() {
        return HasGeneratedSources$GeneratedSources$.MODULE$.apply((scala.collection.immutable.Seq<GeneratedSource>)scala.package$.MODULE$.Nil());
    }

    private final Option sourcesItemOpt$1(Scope scope) {
        return this.targetScopeIdOpt(scope).map((Function1 & Serializable)id -> {
            scala.collection.immutable.Seq items = (scala.collection.immutable.Seq)((HasGeneratedSources.GeneratedSources)this.generatedSources().getOrElse((Object)scope, BspServer::$anonfun$15)).sources().flatMap((Function1 & Serializable)s -> (IterableOnce)((IterableOps)s.reportingPath().toSeq().map((Function1 & Serializable)_$13 -> _$13.toNIO().toUri().toASCIIString())).map((Function1 & Serializable)uri -> {
                WrappedSourceItem item = new WrappedSourceItem(uri, s.generated().toNIO().toUri().toASCIIString());
                String content = read$.MODULE$.apply((ReadablePath)s.generated());
                item.setTopWrapper(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(content), s.topWrapperLen()));
                item.setBottomWrapper("}");
                return item;
            }));
            return new WrappedSourcesItem(id, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)items).asJava());
        });
    }
}

