/*
 * Decompiled with CFR 0.152.
 */
package scala.build.postprocessing;

import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import os.Path;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.build.Logger;
import scala.build.postprocessing.AsmPositionUpdater$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

public final class AsmPositionUpdater {
    public static void postProcess(Map<String, Tuple2<String, Object>> map, Path path, Logger logger) {
        AsmPositionUpdater$.MODULE$.postProcess(map, path, logger);
    }

    public static class LineNumberTableClassVisitor
    extends ClassVisitor {
        private final Map<String, Tuple2<String, Object>> mappings;
        private Option<Object> lineShiftOpt;

        public LineNumberTableClassVisitor(Map<String, Tuple2<String, Object>> mappings, ClassWriter cw) {
            this.mappings = mappings;
            super(589824, (ClassVisitor)cw);
            this.lineShiftOpt = Option$.MODULE$.empty();
        }

        public boolean mappedStuff() {
            return this.lineShiftOpt.nonEmpty();
        }

        public void visitSource(String source, String debug) {
            Tuple2 tuple2;
            Option option = this.mappings.get((Object)source);
            if (None$.MODULE$.equals(option)) {
                super.visitSource(source, debug);
                return;
            }
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                String newSource = (String)tuple2._1();
                int lineShift = BoxesRunTime.unboxToInt((Object)tuple2._2());
                this.lineShiftOpt = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)lineShift));
                super.visitSource(newSource, debug);
                return;
            }
            throw new MatchError((Object)option);
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor main = super.visitMethod(access, name, descriptor, signature, exceptions);
            Option<Object> option = this.lineShiftOpt;
            if (None$.MODULE$.equals(option)) {
                return main;
            }
            if (option instanceof Some) {
                int lineShift = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                return new LineNumberTableMethodVisitor(lineShift, main);
            }
            throw new MatchError(option);
        }
    }

    public static class LineNumberTableMethodVisitor
    extends MethodVisitor {
        private final int lineShift;

        public LineNumberTableMethodVisitor(int lineShift, MethodVisitor delegate) {
            this.lineShift = lineShift;
            super(589824, delegate);
        }

        public void visitLineNumber(int line, Label start) {
            super.visitLineNumber(line + this.lineShift, start);
        }
    }
}

