/*
 * Decompiled with CFR 0.152.
 */
package scala.build.preprocessing;

import com.virtuslab.using_directives.Context;
import com.virtuslab.using_directives.UsingDirectivesProcessor;
import com.virtuslab.using_directives.config.Settings;
import com.virtuslab.using_directives.custom.model.UsingDirectiveKind;
import com.virtuslab.using_directives.custom.model.UsingDirectiveSyntax;
import com.virtuslab.using_directives.custom.model.UsingDirectives;
import com.virtuslab.using_directives.custom.utils.Position;
import com.virtuslab.using_directives.custom.utils.ast.UsingDefs;
import com.virtuslab.using_directives.custom.utils.ast.UsingTree;
import com.virtuslab.using_directives.reporter.Reporter;
import java.io.Serializable;
import os.Path;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.build.Logger;
import scala.build.Position;
import scala.build.errors.BuildException;
import scala.build.errors.CompositeBuildException$;
import scala.build.errors.Diagnostic;
import scala.build.errors.DirectiveErrors;
import scala.build.errors.MalformedDirectiveError;
import scala.build.errors.Severity;
import scala.build.preprocessing.CustomDirectivesReporter;
import scala.build.preprocessing.CustomDirectivesReporter$;
import scala.build.preprocessing.DirectivesPositions;
import scala.build.preprocessing.DirectivesPositions$;
import scala.build.preprocessing.ExtractedDirectives;
import scala.build.preprocessing.ScopePath;
import scala.build.preprocessing.directives.DirectiveUtil$;
import scala.build.preprocessing.directives.ScopedDirective$;
import scala.build.preprocessing.directives.StrictDirective;
import scala.build.preprocessing.directives.StrictDirective$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.deriving.Mirror;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;

public final class ExtractedDirectives$
implements Mirror.Product,
Serializable {
    private static final String changeToSpecialCommentMsg;
    public static final ExtractedDirectives$ MODULE$;

    private ExtractedDirectives$() {
    }

    static {
        MODULE$ = new ExtractedDirectives$();
        changeToSpecialCommentMsg = "Using directive using plain comments are deprecated. Please use a special comment syntax: '//> ...' or '/*> ... */'";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ExtractedDirectives$.class);
    }

    public ExtractedDirectives apply(int offset, Seq<StrictDirective> directives, Option<DirectivesPositions> positions) {
        return new ExtractedDirectives(offset, directives, positions);
    }

    public ExtractedDirectives unapply(ExtractedDirectives x$1) {
        return x$1;
    }

    public String toString() {
        return "ExtractedDirectives";
    }

    public ExtractedDirectives empty() {
        return this.apply(0, (Seq<StrictDirective>)((Seq)package$.MODULE$.Seq().empty()), (Option<DirectivesPositions>)None$.MODULE$);
    }

    public String changeToSpecialCommentMsg() {
        return changeToSpecialCommentMsg;
    }

    public Either<BuildException, ExtractedDirectives> from(char[] contentChars, Either<String, Path> path, Logger logger, UsingDirectiveKind[] supportedDirectives, ScopePath cwd, Function1<BuildException, Option<BuildException>> maybeRecoverOnError) {
        None$ maybeCompositeMalformedDirectiveError;
        ListBuffer errors = new ListBuffer();
        CustomDirectivesReporter reporter = CustomDirectivesReporter$.MODULE$.create(path, (Function1<Diagnostic, BoxedUnit>)(JProcedure1 & Serializable)diag -> {
            Severity severity = diag.severity();
            Severity.Warning$ warning$ = Severity.Warning$.MODULE$;
            if (!(severity != null ? !severity.equals(warning$) : warning$ != null)) {
                logger.log((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Diagnostic[]{diag})));
                return;
            }
            errors.$plus$eq(diag);
        });
        Settings settings = new Settings();
        settings.setAllowStartWithoutAt(true);
        settings.setAllowRequire(false);
        Context context = new Context((Reporter)reporter, settings);
        UsingDirectivesProcessor processor = new UsingDirectivesProcessor(context);
        Buffer all = CollectionConverters$.MODULE$.ListHasAsScala(processor.extract(contentChars, true, true)).asScala();
        Seq malformedDirectiveErrors = ((IterableOnceOps)errors.map((Function1 & Serializable)diag -> new MalformedDirectiveError(diag.message(), diag.positions()))).toSeq();
        Object object = maybeCompositeMalformedDirectiveError = malformedDirectiveErrors.nonEmpty() ? (Option)maybeRecoverOnError.apply((Object)CompositeBuildException$.MODULE$.apply(malformedDirectiveErrors)) : None$.MODULE$;
        if (malformedDirectiveErrors.isEmpty() || maybeCompositeMalformedDirectiveError.isEmpty()) {
            UsingDirectives usingDirectives;
            UsingDirectives codeDirectives = this.byKind$1(all, UsingDirectiveKind.Code);
            UsingDirectives specialCommentDirectives = this.byKind$1(all, UsingDirectiveKind.SpecialComment);
            UsingDirectives plainCommentDirectives = this.byKind$1(all, UsingDirectiveKind.PlainComment);
            DirectivesPositions directivesPositions = DirectivesPositions$.MODULE$.apply(this.getPosition$1(path, codeDirectives), this.getPosition$1(path, specialCommentDirectives), this.getPosition$1(path, plainCommentDirectives));
            if (!codeDirectives.getFlattenedMap().isEmpty()) {
                String msg = "This using directive is ignored. File contains directives outside comments and those have higher precedence.";
                this.reportWarning$1(path, logger, msg, (Seq)this.getDirectives$1(plainCommentDirectives).$plus$plus((IterableOnce)this.getDirectives$1(specialCommentDirectives)), this.reportWarning$default$3$1());
                usingDirectives = codeDirectives;
            } else if (!specialCommentDirectives.getFlattenedMap().isEmpty()) {
                String msg = new StringBuilder(33).append("This using directive is ignored. ").append(this.changeToSpecialCommentMsg()).toString();
                this.reportWarning$1(path, logger, msg, this.getDirectives$1(plainCommentDirectives), this.reportWarning$default$3$1());
                usingDirectives = specialCommentDirectives;
            } else {
                this.reportWarning$1(path, logger, this.changeToSpecialCommentMsg(), this.getDirectives$1(plainCommentDirectives), this.reportWarning$default$3$1());
                usingDirectives = plainCommentDirectives;
            }
            UsingDirectives usedDirectives = usingDirectives;
            this.reportWarning$1(path, logger, "Deprecated using directive syntax, please use keyword `using`.", (Seq)this.getDirectives$1(usedDirectives).filter((Function1 & Serializable)_$2 -> {
                UsingDirectiveSyntax usingDirectiveSyntax = _$2.getSyntax();
                UsingDirectiveSyntax usingDirectiveSyntax2 = UsingDirectiveSyntax.Using;
                return usingDirectiveSyntax == null ? usingDirectiveSyntax2 != null : !usingDirectiveSyntax.equals(usingDirectiveSyntax2);
            }), false);
            Seq flattened = CollectionConverters$.MODULE$.MapHasAsScala(usedDirectives.getFlattenedMap()).asScala().toSeq();
            Seq strictDirectives = (Seq)flattened.map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    com.virtuslab.using_directives.custom.model.Path k = (com.virtuslab.using_directives.custom.model.Path)tuple2._1();
                    java.util.List l = (java.util.List)tuple2._2();
                    return StrictDirective$.MODULE$.apply(CollectionConverters$.MODULE$.ListHasAsScala(k.getPath()).asScala().mkString("."), CollectionConverters$.MODULE$.ListHasAsScala(l).asScala().toSeq());
                }
                throw new MatchError((Object)tuple2);
            });
            UsingDirectiveKind usingDirectiveKind = usedDirectives.getKind();
            UsingDirectiveKind usingDirectiveKind2 = UsingDirectiveKind.Code;
            int offset = (usingDirectiveKind == null ? usingDirectiveKind2 != null : !usingDirectiveKind.equals(usingDirectiveKind2)) ? 0 : usedDirectives.getCodeOffset();
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])supportedDirectives);
            if (ArrayOps$.MODULE$.contains$extension(object2, (Object)usedDirectives.getKind())) {
                return package$.MODULE$.Right().apply((Object)this.apply(offset, (Seq<StrictDirective>)strictDirectives, (Option<DirectivesPositions>)Some$.MODULE$.apply((Object)directivesPositions)));
            }
            List directiveVales = CollectionConverters$.MODULE$.CollectionHasAsScala(usedDirectives.getFlattenedMap().values()).asScala().toList().flatMap((Function1 & Serializable)_$3 -> CollectionConverters$.MODULE$.ListHasAsScala(_$3).asScala());
            Seq values = DirectiveUtil$.MODULE$.concatAllValues(DirectiveUtil$.MODULE$.getGroupedValues(ScopedDirective$.MODULE$.apply(StrictDirective$.MODULE$.apply("", (Seq)directiveVales), path, cwd)));
            DirectiveErrors directiveErrors = new DirectiveErrors(package$.MODULE$.$colon$colon().apply((Object)new StringBuilder(51).append("Directive '").append(usedDirectives.getKind()).append("' is not supported in the given context'").toString(), (List)package$.MODULE$.Nil()), (Seq)values.flatMap((Function1 & Serializable)_$4 -> _$4.positioned().positions()));
            Option option = (Option)maybeRecoverOnError.apply((Object)directiveErrors);
            if (option instanceof Some) {
                BuildException e = (BuildException)((Some)option).value();
                return package$.MODULE$.Left().apply((Object)e);
            }
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Right().apply((Object)this.empty());
            }
            throw new MatchError((Object)option);
        }
        None$ none$ = maybeCompositeMalformedDirectiveError;
        if (none$ instanceof Some) {
            BuildException e = (BuildException)((Some)none$).value();
            return package$.MODULE$.Left().apply((Object)e);
        }
        if (None$.MODULE$.equals(none$)) {
            return package$.MODULE$.Right().apply((Object)this.empty());
        }
        throw new MatchError((Object)none$);
    }

    public ExtractedDirectives fromProduct(Product x$0) {
        return new ExtractedDirectives(BoxesRunTime.unboxToInt((Object)x$0.productElement(0)), (Seq<StrictDirective>)((Seq)x$0.productElement(1)), (Option<DirectivesPositions>)((Option)x$0.productElement(2)));
    }

    private final UsingDirectives byKind$1(Buffer all$1, UsingDirectiveKind kind) {
        return (UsingDirectives)all$1.find((Function1 & Serializable)_$1 -> {
            UsingDirectiveKind usingDirectiveKind = _$1.getKind();
            UsingDirectiveKind usingDirectiveKind2 = kind;
            return !(usingDirectiveKind != null ? !usingDirectiveKind.equals(usingDirectiveKind2) : usingDirectiveKind2 != null);
        }).get();
    }

    private final Seq getDirectives$1(UsingDirectives directives) {
        UsingTree usingTree = directives.getAst();
        if (usingTree instanceof UsingDefs) {
            UsingDefs ud = (UsingDefs)usingTree;
            return CollectionConverters$.MODULE$.ListHasAsScala(ud.getUsingDefs()).asScala().toSeq();
        }
        return package$.MODULE$.Nil();
    }

    private final Position.File getPosition$1(Either path$1, UsingDirectives directives) {
        int line = directives.getAst().getPosition().getLine();
        int column = directives.getAst().getPosition().getColumn();
        return Position.File$.MODULE$.apply(path$1, (Tuple2)new Tuple2.mcII.sp(0, 0), (Tuple2)new Tuple2.mcII.sp(line, column));
    }

    private final void reportWarning$1(Either path$3, Logger logger$3, String msg, Seq values, boolean before) {
        values.foreach((Function1)(JProcedure1 & Serializable)v -> {
            Position astPos = v.getPosition();
            Tuple2 tuple2 = before ? Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)astPos.getColumn())) : Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)astPos.getColumn()), (Object)BoxesRunTime.boxToInteger((int)(astPos.getColumn() + v.getSyntax().getKeyword().length())));
            int start = tuple2._1$mcI$sp();
            int end = tuple2._2$mcI$sp();
            Position.File position = Position.File$.MODULE$.apply(path$3, Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)astPos.getLine()), (Object)BoxesRunTime.boxToInteger((int)start)), Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)astPos.getLine()), (Object)BoxesRunTime.boxToInteger((int)end)));
            Seq seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Position.File[]{position}));
            Severity severity = logger$3.diagnostic$default$2();
            logger$3.diagnostic(msg, severity, seq);
        });
    }

    private final boolean reportWarning$default$3$1() {
        return true;
    }
}

