/*
 * Decompiled with CFR 0.152.
 */
package scala.build.bsp;

import bloop.rifle.BloopRifleConfig;
import bloop.rifle.BloopServer;
import bloop.rifle.BloopServer$;
import ch.epfl.scala.bsp4j.BuildClient;
import ch.epfl.scala.bsp4j.BuildServer;
import ch.epfl.scala.bsp4j.BuildTargetEvent;
import ch.epfl.scala.bsp4j.BuildTargetEventKind;
import ch.epfl.scala.bsp4j.BuildTargetIdentifier;
import ch.epfl.scala.bsp4j.CompileReport;
import ch.epfl.scala.bsp4j.CompileResult;
import ch.epfl.scala.bsp4j.CompileTask;
import ch.epfl.scala.bsp4j.DidChangeBuildTarget;
import ch.epfl.scala.bsp4j.MessageType;
import ch.epfl.scala.bsp4j.ScalaBuildServer;
import ch.epfl.scala.bsp4j.ShowMessageParams;
import ch.epfl.scala.bsp4j.StatusCode;
import ch.epfl.scala.bsp4j.TaskFinishParams;
import ch.epfl.scala.bsp4j.TaskId;
import ch.epfl.scala.bsp4j.TaskStartParams;
import com.github.plokhotnyuk.jsoniter_scala.core.JsonReaderException;
import com.swoval.files.PathWatcher;
import com.swoval.files.PathWatchers;
import coursier.cache.ArchiveCache;
import dependency.ScalaParameters;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import os.Path;
import os.PathChunk;
import os.PathChunk$;
import os.ReadablePath;
import os.isFile$;
import os.read;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple5;
import scala.Tuple5$;
import scala.build.Artifacts;
import scala.build.BloopBuildClient;
import scala.build.Build;
import scala.build.Build$;
import scala.build.CrossSources;
import scala.build.CrossSources$;
import scala.build.EitherCps$;
import scala.build.GeneratedSource;
import scala.build.Logger;
import scala.build.PersistentDiagnosticLogger;
import scala.build.Positioned;
import scala.build.Project;
import scala.build.ScopedSources;
import scala.build.Sources;
import scala.build.Sources$;
import scala.build.bsp.BloopSession;
import scala.build.bsp.BloopSession$;
import scala.build.bsp.Bsp;
import scala.build.bsp.BspClient;
import scala.build.bsp.BspClient$;
import scala.build.bsp.BspImpl$;
import scala.build.bsp.BspImpl$PreBuildData$;
import scala.build.bsp.BspImpl$PreBuildProject$;
import scala.build.bsp.BspReloadableOptions;
import scala.build.bsp.BspServer;
import scala.build.bsp.BspThreads;
import scala.build.bsp.BuildServerProxy;
import scala.build.bsp.HasGeneratedSources;
import scala.build.bsp.IdeInputs;
import scala.build.bsp.IdeInputs$;
import scala.build.bsp.LoggingBuildClient;
import scala.build.bsp.LoggingBuildServerAll;
import scala.build.compiler.BloopCompiler;
import scala.build.errors.BuildException;
import scala.build.errors.CompositeBuildException;
import scala.build.errors.Diagnostic;
import scala.build.errors.ParsingInputsException;
import scala.build.input.Inputs;
import scala.build.input.ScalaCliInvokeData;
import scala.build.internal.Constants$;
import scala.build.options.BuildOptions;
import scala.build.options.Scope;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FileName$;
import sourcecode.Line$;
import sourcecode.Text$;

public final class BspImpl
implements Bsp {
    private final Function1<scala.collection.immutable.Seq<String>, Either<BuildException, Inputs>> argsToInputs;
    private final BspReloadableOptions.Reference bspReloadableOptionsReference;
    private final BspThreads threads;
    private final InputStream in;
    private final OutputStream out;
    private final Option<Object> actionableDiagnostics;
    private final ScalaCliInvokeData x$7;
    private final ConcurrentHashMap<String, BoxedUnit> shownGlobalMessages;
    private BspClient actualLocalClient;
    private BloopBuildClient localClient;
    private final BloopSession.Reference bloopSession;

    public BspImpl(Function1<scala.collection.immutable.Seq<String>, Either<BuildException, Inputs>> argsToInputs, BspReloadableOptions.Reference bspReloadableOptionsReference, BspThreads threads, InputStream in, OutputStream out, Option<Object> actionableDiagnostics, ScalaCliInvokeData x$7) {
        this.argsToInputs = argsToInputs;
        this.bspReloadableOptionsReference = bspReloadableOptionsReference;
        this.threads = threads;
        this.in = in;
        this.out = out;
        this.actionableDiagnostics = actionableDiagnostics;
        this.x$7 = x$7;
        this.shownGlobalMessages = new ConcurrentHashMap();
        this.bloopSession = new BloopSession.Reference();
    }

    private void notifyBuildChange(BloopSession currentBloopSession) {
        List events = currentBloopSession.bspServer().targetIds().map((Function1 & Serializable)targetId -> {
            BuildTargetEvent event = new BuildTargetEvent(targetId);
            event.setKind(BuildTargetEventKind.CHANGED);
            return event;
        });
        DidChangeBuildTarget params = new DidChangeBuildTarget(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)events).asJava());
        this.actualLocalClient.onBuildTargetDidChange(params);
    }

    private Either<Tuple2<BuildException, Scope>, PreBuildProject> prepareBuild(BloopSession currentBloopSession, BspReloadableOptions reloadableOptions, Function1<Scope, Function1<BuildException, Option<BuildException>>> maybeRecoverOnError) {
        return EitherCps$.MODULE$.either().apply((Function1 & Serializable)evidence$1 -> {
            Logger logger = reloadableOptions.logger();
            BuildOptions buildOptions = reloadableOptions.buildOptions();
            int verbosity = reloadableOptions.verbosity();
            logger.log(BspImpl::prepareBuild$$anonfun$1$$anonfun$1);
            PersistentDiagnosticLogger persistentLogger = new PersistentDiagnosticLogger(logger);
            BspServer bspServer = currentBloopSession.bspServer();
            Inputs inputs = currentBloopSession.inputs();
            Tuple2 tuple2 = (Tuple2)EitherCps$.MODULE$.value(evidence$1, CrossSources$.MODULE$.forInputs(inputs, Sources$.MODULE$.defaultPreprocessors((ArchiveCache<Function1>)buildOptions.archiveCache(), (Option<String>)buildOptions.internal().javaClassNameVersionOpt(), (Function0<String>)(Function0 & Serializable)() -> ((BuildOptions.JavaHomeInfo)buildOptions.javaHome().value()).javaCommand()), persistentLogger, buildOptions.suppressWarningOptions(), (scala.collection.immutable.Seq<Positioned<String>>)buildOptions.internal().exclude(), (Function1<BuildException, Option<BuildException>>)((Function1)maybeRecoverOnError.apply((Object)Scope.Main$.MODULE$)), this.x$7).left().map((Function1 & Serializable)_$2 -> Tuple2$.MODULE$.apply(_$2, (Object)Scope.Main$.MODULE$)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            CrossSources crossSources = (CrossSources)tuple2._1();
            Inputs allInputs = (Inputs)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)crossSources, (Object)allInputs);
            CrossSources crossSources2 = (CrossSources)tuple22._1();
            Inputs allInputs2 = (Inputs)tuple22._2();
            BuildOptions sharedOptions = crossSources2.sharedOptions(buildOptions);
            if (verbosity >= 3) {
                pprint.package$.MODULE$.err().log(Text$.MODULE$.apply((Object)crossSources2, "crossSources"), pprint.package$.MODULE$.err().log$default$2(), pprint.package$.MODULE$.err().log$default$3(), pprint.package$.MODULE$.err().log$default$4(), pprint.package$.MODULE$.err().log$default$5(), pprint.package$.MODULE$.err().log$default$6(), pprint.package$.MODULE$.err().log$default$7(), Line$.MODULE$.apply(117), FileName$.MODULE$.apply("BspImpl.scala"));
            }
            ScopedSources scopedSources = (ScopedSources)EitherCps$.MODULE$.value(evidence$1, crossSources2.scopedSources(buildOptions).left().map((Function1 & Serializable)_$3 -> Tuple2$.MODULE$.apply(_$3, (Object)Scope.Main$.MODULE$)));
            if (verbosity >= 3) {
                pprint.package$.MODULE$.err().log(Text$.MODULE$.apply((Object)scopedSources, "scopedSources"), pprint.package$.MODULE$.err().log$default$2(), pprint.package$.MODULE$.err().log$default$3(), pprint.package$.MODULE$.err().log$default$4(), pprint.package$.MODULE$.err().log$default$5(), pprint.package$.MODULE$.err().log$default$6(), pprint.package$.MODULE$.err().log$default$7(), Line$.MODULE$.apply(123), FileName$.MODULE$.apply("BspImpl.scala"));
            }
            Sources sourcesMain = (Sources)EitherCps$.MODULE$.value(evidence$1, scopedSources.sources((Scope)Scope.Main$.MODULE$, sharedOptions, allInputs2.workspace(), persistentLogger).left().map((Function1 & Serializable)_$4 -> Tuple2$.MODULE$.apply(_$4, (Object)Scope.Main$.MODULE$)));
            Sources sourcesTest = (Sources)EitherCps$.MODULE$.value(evidence$1, scopedSources.sources((Scope)Scope.Test$.MODULE$, sharedOptions, allInputs2.workspace(), persistentLogger).left().map((Function1 & Serializable)_$5 -> Tuple2$.MODULE$.apply(_$5, (Object)Scope.Test$.MODULE$)));
            if (verbosity >= 3) {
                pprint.package$.MODULE$.err().log(Text$.MODULE$.apply((Object)sourcesMain, "sourcesMain"), pprint.package$.MODULE$.err().log$default$2(), pprint.package$.MODULE$.err().log$default$3(), pprint.package$.MODULE$.err().log$default$4(), pprint.package$.MODULE$.err().log$default$5(), pprint.package$.MODULE$.err().log$default$6(), pprint.package$.MODULE$.err().log$default$7(), Line$.MODULE$.apply(136), FileName$.MODULE$.apply("BspImpl.scala"));
            }
            BuildOptions options0Main = sourcesMain.buildOptions();
            BuildOptions options0Test = sourcesTest.buildOptions().orElse(options0Main);
            scala.collection.immutable.Seq<GeneratedSource> generatedSourcesMain = sourcesMain.generateSources(allInputs2.generatedSrcRoot((Scope)Scope.Main$.MODULE$));
            scala.collection.immutable.Seq<GeneratedSource> generatedSourcesTest = sourcesTest.generateSources(allInputs2.generatedSrcRoot((Scope)Scope.Test$.MODULE$));
            bspServer.setExtraDependencySources((scala.collection.immutable.Seq<Path>)options0Main.classPathOptions().extraSourceJars());
            bspServer.setExtraTestDependencySources((scala.collection.immutable.Seq<Path>)options0Test.classPathOptions().extraSourceJars());
            bspServer.setGeneratedSources((Scope)Scope.Main$.MODULE$, (scala.collection.immutable.Seq)generatedSourcesMain);
            bspServer.setGeneratedSources((Scope)Scope.Test$.MODULE$, (scala.collection.immutable.Seq)generatedSourcesTest);
            Either<BuildException, Tuple5<Path, Option<ScalaParameters>, Artifacts, Project, Object>> res = Build$.MODULE$.prepareBuild(allInputs2, sourcesMain, generatedSourcesMain, options0Main, (Option<Positioned<Object>>)None$.MODULE$, (Scope)Scope.Main$.MODULE$, currentBloopSession.remoteServer(), persistentLogger, this.localClient, (Function1<BuildException, Option<BuildException>>)((Function1)maybeRecoverOnError.apply((Object)Scope.Main$.MODULE$)));
            Tuple5 tuple5 = (Tuple5)EitherCps$.MODULE$.value(evidence$1, res.left().map((Function1 & Serializable)_$6 -> Tuple2$.MODULE$.apply(_$6, (Object)Scope.Main$.MODULE$)));
            if (tuple5 == null) {
                throw new MatchError((Object)tuple5);
            }
            Path classesDir0Main = (Path)tuple5._1();
            Option scalaParamsMain = (Option)tuple5._2();
            Artifacts artifactsMain = (Artifacts)tuple5._3();
            Project projectMain = (Project)tuple5._4();
            boolean buildChangedMain = BoxesRunTime.unboxToBoolean((Object)tuple5._5());
            Tuple5 tuple52 = Tuple5$.MODULE$.apply((Object)classesDir0Main, (Object)scalaParamsMain, (Object)artifactsMain, (Object)projectMain, (Object)BoxesRunTime.boxToBoolean((boolean)buildChangedMain));
            Path classesDir0Main2 = (Path)tuple52._1();
            Option scalaParamsMain2 = (Option)tuple52._2();
            Artifacts artifactsMain2 = (Artifacts)tuple52._3();
            Project projectMain2 = (Project)tuple52._4();
            boolean buildChangedMain2 = BoxesRunTime.unboxToBoolean((Object)tuple52._5());
            Either<BuildException, Tuple5<Path, Option<ScalaParameters>, Artifacts, Project, Object>> res2 = Build$.MODULE$.prepareBuild(allInputs2, sourcesTest, generatedSourcesTest, options0Test, (Option<Positioned<Object>>)None$.MODULE$, (Scope)Scope.Test$.MODULE$, currentBloopSession.remoteServer(), persistentLogger, this.localClient, (Function1<BuildException, Option<BuildException>>)((Function1)maybeRecoverOnError.apply((Object)Scope.Test$.MODULE$)));
            Tuple5 tuple53 = (Tuple5)EitherCps$.MODULE$.value(evidence$1, res2.left().map((Function1 & Serializable)_$7 -> Tuple2$.MODULE$.apply(_$7, (Object)Scope.Test$.MODULE$)));
            if (tuple53 == null) {
                throw new MatchError((Object)tuple53);
            }
            Path classesDir0Test = (Path)tuple53._1();
            Option scalaParamsTest = (Option)tuple53._2();
            Artifacts artifactsTest = (Artifacts)tuple53._3();
            Project projectTest = (Project)tuple53._4();
            boolean buildChangedTest = BoxesRunTime.unboxToBoolean((Object)tuple53._5());
            Tuple5 tuple54 = Tuple5$.MODULE$.apply((Object)classesDir0Test, (Object)scalaParamsTest, (Object)artifactsTest, (Object)projectTest, (Object)BoxesRunTime.boxToBoolean((boolean)buildChangedTest));
            Path classesDir0Test2 = (Path)tuple54._1();
            Option scalaParamsTest2 = (Option)tuple54._2();
            Artifacts artifactsTest2 = (Artifacts)tuple54._3();
            Project projectTest2 = (Project)tuple54._4();
            boolean buildChangedTest2 = BoxesRunTime.unboxToBoolean((Object)tuple54._5());
            this.localClient.setGeneratedSources((Scope)Scope.Main$.MODULE$, generatedSourcesMain);
            this.localClient.setGeneratedSources((Scope)Scope.Test$.MODULE$, generatedSourcesTest);
            PreBuildData mainScope = BspImpl$PreBuildData$.MODULE$.apply(sourcesMain, options0Main, classesDir0Main2, (Option<ScalaParameters>)scalaParamsMain2, artifactsMain2, projectMain2, generatedSourcesMain, buildChangedMain2);
            PreBuildData testScope = BspImpl$PreBuildData$.MODULE$.apply(sourcesTest, options0Test, classesDir0Test2, (Option<ScalaParameters>)scalaParamsTest2, artifactsTest2, projectTest2, generatedSourcesTest, buildChangedTest2);
            if (BoxesRunTime.unboxToBoolean((Object)this.actionableDiagnostics.getOrElse(BspImpl::prepareBuild$$anonfun$1$$anonfun$2))) {
                BuildOptions projectOptions = options0Test.orElse(options0Main);
                projectOptions.logActionableDiagnostics((Logger)persistentLogger);
            }
            return BspImpl$PreBuildProject$.MODULE$.apply(mainScope, testScope, (scala.collection.immutable.Seq<Diagnostic>)persistentLogger.diagnostics());
        });
    }

    private Function1<Scope, Function1<BuildException, Option<BuildException>>> prepareBuild$default$3() {
        return (Function1 & Serializable)_$1 -> (Function1 & Serializable)e -> Some$.MODULE$.apply(e);
    }

    private Either<Tuple2<BuildException, Scope>, BoxedUnit> buildE(BloopSession currentBloopSession, boolean notifyChanges, BspReloadableOptions reloadableOptions) {
        return EitherCps$.MODULE$.either().apply((Function1)(JProcedure1 & Serializable)evidence$2 -> {
            PreBuildProject preBuild = (PreBuildProject)EitherCps$.MODULE$.value(evidence$2, this.prepareBuild(currentBloopSession, reloadableOptions, this.prepareBuild$default$3()));
            if (notifyChanges && (preBuild.mainScope().buildChanged() || preBuild.testScope().buildChanged())) {
                this.notifyBuildChange(currentBloopSession);
            }
            EitherCps$.MODULE$.value(evidence$2, this.doBuildOnce$1(currentBloopSession, reloadableOptions, preBuild.mainScope(), (Scope)Scope.Main$.MODULE$));
            EitherCps$.MODULE$.value(evidence$2, this.doBuildOnce$1(currentBloopSession, reloadableOptions, preBuild.testScope(), (Scope)Scope.Test$.MODULE$));
        });
    }

    private void build(BloopSession currentBloopSession, BspClient client, boolean notifyChanges, BspReloadableOptions reloadableOptions) {
        Tuple2 tuple2;
        Either<Tuple2<BuildException, Scope>, BoxedUnit> either = this.buildE(currentBloopSession, notifyChanges, reloadableOptions);
        if (either instanceof Left && (tuple2 = (Tuple2)((Left)either).value()) != null) {
            BuildException ex = (BuildException)tuple2._1();
            Scope scope = (Scope)tuple2._2();
            client.reportBuildException((Option<BuildTargetIdentifier>)currentBloopSession.bspServer().targetScopeIdOpt(scope), ex, client.reportBuildException$default$3());
            reloadableOptions.logger().debug(() -> BspImpl.build$$anonfun$1(ex));
            return;
        }
        if (either instanceof Right) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Object object = ((Right)either).value();
            if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                currentBloopSession.bspServer().targetIds().foreach((Function1)(JProcedure1 & Serializable)targetId -> client.resetBuildExceptionDiagnostics((BuildTargetIdentifier)targetId));
                return;
            }
        }
        throw new MatchError(either);
    }

    private void showGlobalWarningOnce(String msg) {
        this.shownGlobalMessages.computeIfAbsent(msg, _$9 -> {
            this.showGlobalWarningOnce$$anonfun$1(msg, (String)_$9);
            return BoxedUnit.UNIT;
        });
    }

    private CompletableFuture<CompileResult> compile(BloopSession currentBloopSession, Executor executor, BspReloadableOptions reloadableOptions, Function0<CompletableFuture<CompileResult>> doCompile) {
        CompletableFuture<Either> preBuild = CompletableFuture.supplyAsync(() -> {
            Tuple2 tuple2;
            Either<Tuple2<BuildException, Scope>, PreBuildProject> either = this.prepareBuild(currentBloopSession, reloadableOptions, this.prepareBuild$default$3());
            if (either instanceof Right) {
                PreBuildProject preBuild = (PreBuildProject)((Right)either).value();
                if (preBuild.mainScope().buildChanged() || preBuild.testScope().buildChanged()) {
                    this.notifyBuildChange(currentBloopSession);
                }
                return package$.MODULE$.Right().apply((Object)preBuild);
            }
            if (either instanceof Left && (tuple2 = (Tuple2)((Left)either).value()) != null) {
                BuildException ex = (BuildException)tuple2._1();
                Scope scope = (Scope)tuple2._2();
                return package$.MODULE$.Left().apply((Object)Tuple2$.MODULE$.apply((Object)ex, (Object)scope));
            }
            throw new MatchError(either);
        }, executor);
        return preBuild.thenCompose(x$1 -> {
            Tuple2 tuple2;
            Either either = x$1;
            if (either instanceof Left && (tuple2 = (Tuple2)((Left)either).value()) != null) {
                BuildException ex = (BuildException)tuple2._1();
                Scope scope = (Scope)tuple2._2();
                TaskId taskId = new TaskId(UUID.randomUUID().toString());
                currentBloopSession.bspServer().targetScopeIdOpt(scope).foreach((Function1)(JProcedure1 & Serializable)targetId -> {
                    int n;
                    String string;
                    scala.collection.immutable.Seq seq;
                    Option option;
                    String string2 = targetId.getUri();
                    if (string2 != null && !(option = StringContext$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "?id=", ""})).s().unapplySeq(string2)).isEmpty() && (seq = (scala.collection.immutable.Seq)option.get()).lengthCompare(2) == 0) {
                        String string3;
                        String targetId2;
                        String string4 = (String)seq.apply(0);
                        string = targetId2 = (string3 = (String)seq.apply(1));
                    } else {
                        String targetIdUri;
                        string = targetIdUri = string2;
                    }
                    String target = string;
                    TaskStartParams taskStartParams = new TaskStartParams(taskId);
                    taskStartParams.setEventTime(Predef$.MODULE$.long2Long(System.currentTimeMillis()));
                    taskStartParams.setMessage(new StringBuilder(16).append("Preprocessing '").append(target).append("'").toString());
                    taskStartParams.setDataKind("compile-task");
                    taskStartParams.setData((Object)new CompileTask(targetId));
                    this.actualLocalClient.onBuildTaskStart(taskStartParams);
                    BspClient bspClient = this.actualLocalClient;
                    bspClient.reportBuildException((Option<BuildTargetIdentifier>)Some$.MODULE$.apply(targetId), ex, bspClient.reportBuildException$default$3());
                    TaskFinishParams taskFinishParams = new TaskFinishParams(taskId, StatusCode.ERROR);
                    taskFinishParams.setEventTime(Predef$.MODULE$.long2Long(System.currentTimeMillis()));
                    taskFinishParams.setMessage(new StringBuilder(15).append("Preprocessed '").append(target).append("'").toString());
                    taskFinishParams.setDataKind("compile-report");
                    BuildException buildException = ex;
                    if (buildException instanceof CompositeBuildException) {
                        CompositeBuildException c = (CompositeBuildException)buildException;
                        n = c.exceptions().size();
                    } else {
                        n = 1;
                    }
                    int errorSize = n;
                    taskFinishParams.setData((Object)new CompileReport(targetId, Predef$.MODULE$.int2Integer(errorSize), Predef$.MODULE$.int2Integer(0)));
                    this.actualLocalClient.onBuildTaskFinish(taskFinishParams);
                });
                return CompletableFuture.completedFuture(new CompileResult(StatusCode.ERROR));
            }
            if (either instanceof Right) {
                PreBuildProject params = (PreBuildProject)((Right)either).value();
                currentBloopSession.bspServer().targetIds().foreach((Function1)(JProcedure1 & Serializable)targetId -> this.actualLocalClient.resetBuildExceptionDiagnostics((BuildTargetIdentifier)targetId));
                BuildTargetIdentifier targetId2 = (BuildTargetIdentifier)currentBloopSession.bspServer().targetIds().head();
                this.actualLocalClient.reportDiagnosticsForFiles(targetId2, params.diagnostics(), false);
                return ((CompletableFuture)doCompile.apply()).thenCompose(res -> {
                    StatusCode statusCode = res.getStatusCode();
                    StatusCode statusCode2 = StatusCode.OK;
                    if (!(statusCode != null ? !statusCode.equals(statusCode2) : statusCode2 != null)) {
                        return CompletableFuture.supplyAsync(() -> {
                            this.doPostProcess$1(currentBloopSession, reloadableOptions, params.mainScope(), (Scope)Scope.Main$.MODULE$);
                            this.doPostProcess$1(currentBloopSession, reloadableOptions, params.testScope(), (Scope)Scope.Test$.MODULE$);
                            return res;
                        }, executor);
                    }
                    return CompletableFuture.completedFuture(res);
                });
            }
            throw new MatchError((Object)either);
        });
    }

    private BloopBuildClient getLocalClient(int verbosity) {
        if (verbosity >= 3) {
            return new LoggingBspClient(this.actualLocalClient);
        }
        return this.actualLocalClient;
    }

    private BloopSession newBloopSession(Inputs inputs, BspReloadableOptions reloadableOptions, boolean presetIntelliJ) {
        LazyRef lazyRef = new LazyRef();
        LazyRef lazyRef2 = new LazyRef();
        LazyRef lazyRef3 = new LazyRef();
        Logger logger = reloadableOptions.logger();
        BuildOptions buildOptions = reloadableOptions.buildOptions();
        Function0 & Serializable createBloopServer = (Function0 & Serializable)() -> BloopServer$.MODULE$.buildServer(reloadableOptions.bloopRifleConfig(), "scala-cli", Constants$.MODULE$.version(), inputs.workspace().$div((PathChunk)PathChunk$.MODULE$.StringPathChunk(Constants$.MODULE$.workspaceDirName())).toNIO(), Build$.MODULE$.classesRootDir(inputs.workspace(), inputs.projectName()).toNIO(), (BuildClient)this.localClient, this.threads.buildThreads().bloop(), logger.bloopRifleLogger());
        BloopCompiler remoteServer = new BloopCompiler((Function0<BloopServer>)createBloopServer, new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(20)).seconds(), buildOptions.internal().strictBloopJsonCheckOrDefault());
        this.bloopSession0$1(inputs, reloadableOptions, presetIntelliJ, logger, remoteServer, lazyRef, lazyRef2, lazyRef3).registerWatchInputs();
        this.bspServer$1(inputs, reloadableOptions, presetIntelliJ, logger, remoteServer, lazyRef, lazyRef2, lazyRef3).newInputs(inputs);
        return this.bloopSession0$1(inputs, reloadableOptions, presetIntelliJ, logger, remoteServer, lazyRef, lazyRef2, lazyRef3);
    }

    private boolean newBloopSession$default$3() {
        return false;
    }

    @Override
    public scala.concurrent.Future<BoxedUnit> run(Inputs initialInputs, BspReloadableOptions initialBspOptions) {
        Object object;
        Tuple2 tuple2;
        Logger logger = initialBspOptions.logger();
        int verbosity = initialBspOptions.verbosity();
        this.actualLocalClient = new BspClient(this.threads.buildThreads().bloop().jsonrpc(), logger, BspClient$.MODULE$.$lessinit$greater$default$3());
        this.localClient = this.getLocalClient(verbosity);
        BloopSession currentBloopSession = this.newBloopSession(initialInputs, initialBspOptions, this.newBloopSession$default$3());
        this.bloopSession.update(null, currentBloopSession, "BSP server already initialized");
        BuildServerProxy actualLocalServer = new BuildServerProxy((Function0<BspServer>)(Function0 & Serializable)() -> this.bloopSession.get().bspServer(), (Function0<CompletableFuture<Object>>)(Function0 & Serializable)() -> this.onReload());
        ScalaBuildServer localServer = verbosity >= 3 ? new LoggingBuildServerAll(actualLocalServer) : actualLocalServer;
        Launcher launcher = new Launcher.Builder().setExecutorService(this.threads.buildThreads().bloop().jsonrpc()).setInput(this.in).setOutput(this.out).setRemoteInterface(BuildClient.class).setLocalService((Object)localServer).create();
        BuildClient remoteClient = (BuildClient)launcher.getRemoteProxy();
        this.actualLocalClient.forwardToOpt_$eq((Option<BuildClient>)Some$.MODULE$.apply((Object)remoteClient));
        this.actualLocalClient.newInputs(initialInputs);
        currentBloopSession.resetDiagnostics(this.actualLocalClient);
        Function1 & Serializable recoverOnError = (Function1 & Serializable)scope -> (Function1 & Serializable)e -> {
            BspClient bspClient = this.actualLocalClient;
            bspClient.reportBuildException(((HasGeneratedSources)actualLocalServer).targetScopeIdOpt((Scope)scope), (BuildException)e, bspClient.reportBuildException$default$3());
            logger.log(e);
            return None$.MODULE$;
        };
        Either<Tuple2<BuildException, Scope>, PreBuildProject> either = this.prepareBuild(currentBloopSession, initialBspOptions, (Function1<Scope, Function1<BuildException, Option<BuildException>>>)recoverOnError);
        if (either instanceof Left && (tuple2 = (Tuple2)((Left)either).value()) != null) {
            BuildException ex = (BuildException)tuple2._1();
            Scope scope2 = (Scope)tuple2._2();
            object = ((Function1)recoverOnError.apply((Object)scope2)).apply((Object)ex);
        } else if (either instanceof Right) {
            object = BoxedUnit.UNIT;
        } else {
            throw new MatchError(either);
        }
        logger.log(BspImpl::run$$anonfun$1);
        Future f = launcher.startListening();
        Runnable initiateFirstBuild = () -> {
            try {
                this.build(currentBloopSession, this.actualLocalClient, false, initialBspOptions);
            }
            catch (Throwable t) {
                logger.debug(() -> BspImpl.$anonfun$14$$anonfun$1(t));
            }
        };
        this.threads.prepareBuildExecutor().submit(initiateFirstBuild);
        ExecutionContextExecutorService es = ExecutionContext$.MODULE$.fromExecutorService(this.threads.buildThreads().bloop().jsonrpc());
        scala.collection.immutable.Seq futures = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.concurrent.Future[]{BspImpl$.MODULE$.scala$build$bsp$BspImpl$$$naiveJavaFutureToScalaFuture(f).map((Function1)(JProcedure1 & Serializable)_$14 -> {}, (ExecutionContext)es), currentBloopSession.bspServer().initiateShutdown()}));
        return Future$.MODULE$.firstCompletedOf((IterableOnce)futures, (ExecutionContext)es);
    }

    @Override
    public void shutdown() {
        this.bloopSession.getAndNullify().foreach((Function1)(JProcedure1 & Serializable)currentBloopSession -> currentBloopSession.dispose());
    }

    private CompletableFuture<Object> reloadBsp(BloopSession currentBloopSession, Inputs previousInputs, Inputs newInputs, BspReloadableOptions reloadableOptions) {
        Tuple2 tuple2;
        List previousTargetIds = currentBloopSession.bspServer().targetIds();
        boolean wasIntelliJ = currentBloopSession.bspServer().isIntelliJ();
        currentBloopSession.dispose();
        BloopSession newBloopSession0 = this.newBloopSession(newInputs, reloadableOptions, wasIntelliJ);
        this.bloopSession.update(currentBloopSession, newBloopSession0, "Concurrent reload of workspace");
        this.actualLocalClient.newInputs(newInputs);
        newBloopSession0.resetDiagnostics(this.actualLocalClient);
        Either<Tuple2<BuildException, Scope>, PreBuildProject> either = this.prepareBuild(newBloopSession0, reloadableOptions, this.prepareBuild$default$3());
        if (either instanceof Left && (tuple2 = (Tuple2)((Left)either).value()) != null) {
            BuildException buildException = (BuildException)tuple2._1();
            Scope scope = (Scope)tuple2._2();
            return CompletableFuture.completedFuture(BspImpl$.MODULE$.scala$build$bsp$BspImpl$$$responseError(new StringBuilder(49).append("Can't reload workspace, build failed for scope ").append(scope.name()).append(": ").append(buildException.message()).toString(), BspImpl$.MODULE$.scala$build$bsp$BspImpl$$$responseError$default$2()));
        }
        if (either instanceof Right) {
            BloopSession bloopSession;
            PreBuildProject preBuildProject = (PreBuildProject)((Right)either).value();
            LazyRef lazyRef = new LazyRef();
            if (this.bloopSession.get().remoteServer().jvmVersion().exists((Function1 & Serializable)_$15 -> BoxesRunTime.unboxToInt((Object)_$15.value()) < BspImpl.projectJavaHome$1(preBuildProject, lazyRef).version())) {
                reloadableOptions.logger().log(() -> this.$anonfun$17(preBuildProject, lazyRef));
                String string = BspImpl.projectJavaHome$1(preBuildProject, lazyRef).javaCommand();
                int n = BspImpl.projectJavaHome$1(preBuildProject, lazyRef).version();
                BloopRifleConfig.Address address = reloadableOptions.bloopRifleConfig().copy$default$1();
                scala.collection.immutable.Seq seq = reloadableOptions.bloopRifleConfig().copy$default$3();
                Function1 function1 = reloadableOptions.bloopRifleConfig().copy$default$4();
                File file = reloadableOptions.bloopRifleConfig().copy$default$5();
                Option option = reloadableOptions.bloopRifleConfig().copy$default$6();
                Option option2 = reloadableOptions.bloopRifleConfig().copy$default$7();
                Option option3 = reloadableOptions.bloopRifleConfig().copy$default$8();
                Option option4 = reloadableOptions.bloopRifleConfig().copy$default$9();
                FiniteDuration finiteDuration = reloadableOptions.bloopRifleConfig().copy$default$10();
                FiniteDuration finiteDuration2 = reloadableOptions.bloopRifleConfig().copy$default$11();
                FiniteDuration finiteDuration3 = reloadableOptions.bloopRifleConfig().copy$default$12();
                FiniteDuration finiteDuration4 = reloadableOptions.bloopRifleConfig().copy$default$13();
                FiniteDuration finiteDuration5 = reloadableOptions.bloopRifleConfig().copy$default$14();
                BloopRifleConfig.BloopVersionConstraint bloopVersionConstraint = reloadableOptions.bloopRifleConfig().copy$default$16();
                BspReloadableOptions updatedReloadableOptions = reloadableOptions.copy(reloadableOptions.buildOptions().orElse(preBuildProject.mainScope().buildOptions()), reloadableOptions.bloopRifleConfig().copy(address, string, seq, function1, file, option, option2, option3, option4, finiteDuration, finiteDuration2, finiteDuration3, finiteDuration4, finiteDuration5, n, bloopVersionConstraint), reloadableOptions.copy$default$3(), reloadableOptions.copy$default$4());
                newBloopSession0.dispose();
                BloopSession bloopSessionWithJvmOkay = this.newBloopSession(newInputs, updatedReloadableOptions, wasIntelliJ);
                this.bloopSession.update(newBloopSession0, bloopSessionWithJvmOkay, "Concurrent reload of workspace");
                bloopSession = bloopSessionWithJvmOkay;
            } else {
                bloopSession = newBloopSession0;
            }
            BloopSession finalBloopSession = bloopSession;
            String string = previousInputs.projectName();
            String string2 = preBuildProject.mainScope().project().projectName();
            if (string == null ? string2 != null : !string.equals(string2)) {
                finalBloopSession.bspServer().clientOpt().foreach((Function1)(JProcedure1 & Serializable)client -> {
                    List newTargetIds = finalBloopSession.bspServer().targetIds();
                    List events = (List)newTargetIds.map((Function1 & Serializable)_$16 -> BspImpl$.MODULE$.scala$build$bsp$BspImpl$$$buildTargetIdToEvent((BuildTargetIdentifier)_$16, BuildTargetEventKind.CREATED)).$plus$plus((IterableOnce)previousTargetIds.map((Function1 & Serializable)_$17 -> BspImpl$.MODULE$.scala$build$bsp$BspImpl$$$buildTargetIdToEvent((BuildTargetIdentifier)_$17, BuildTargetEventKind.DELETED)));
                    DidChangeBuildTarget didChangeBuildTargetParams = new DidChangeBuildTarget(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)events).asJava());
                    client.onBuildTargetDidChange(didChangeBuildTargetParams);
                });
            }
            return CompletableFuture.completedFuture(new Object());
        }
        throw new MatchError(either);
    }

    private CompletableFuture<Object> onReload() {
        BloopSession currentBloopSession = this.bloopSession.get();
        this.bspReloadableOptionsReference.reload();
        BspReloadableOptions reloadableOptions = this.bspReloadableOptionsReference.get();
        Logger logger = reloadableOptions.logger();
        int verbosity = reloadableOptions.verbosity();
        this.actualLocalClient.logger_$eq(logger);
        this.localClient = this.getLocalClient(verbosity);
        Path ideInputsJsonPath = currentBloopSession.inputs().workspace().$div((PathChunk)PathChunk$.MODULE$.StringPathChunk(Constants$.MODULE$.workspaceDirName())).$div((PathChunk)PathChunk$.MODULE$.StringPathChunk("ide-inputs.json"));
        if (isFile$.MODULE$.apply(ideInputsJsonPath)) {
            Either maybeResponse = EitherCps$.MODULE$.either().apply((Function1 & Serializable)evidence$3 -> {
                IdeInputs ideInputs = (IdeInputs)EitherCps$.MODULE$.value(evidence$3, BspImpl.liftedTree1$1(logger, ideInputsJsonPath));
                Inputs newInputs = (Inputs)EitherCps$.MODULE$.value(evidence$3, (Either)this.argsToInputs.apply(ideInputs.args()));
                String newHash = newInputs.sourceHash();
                Inputs previousInputs = currentBloopSession.inputs();
                String previousHash = currentBloopSession.inputsHash();
                Inputs inputs = newInputs;
                Inputs inputs2 = previousInputs;
                if (!(inputs != null ? !((Object)inputs).equals(inputs2) : inputs2 != null)) {
                    String string = newHash;
                    String string2 = previousHash;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return CompletableFuture.completedFuture(new Object());
                    }
                }
                return this.reloadBsp(currentBloopSession, previousInputs, newInputs, reloadableOptions);
            });
            Either either = maybeResponse;
            if (either instanceof Left) {
                BuildException errorMessage = (BuildException)((Left)either).value();
                return CompletableFuture.completedFuture(BspImpl$.MODULE$.scala$build$bsp$BspImpl$$$responseError(new StringBuilder(48).append("Workspace reload failed, couldn't load sources: ").append(errorMessage).toString(), BspImpl$.MODULE$.scala$build$bsp$BspImpl$$$responseError$default$2()));
            }
            if (either instanceof Right) {
                CompletableFuture r = (CompletableFuture)((Right)either).value();
                return r;
            }
            throw new MatchError((Object)either);
        }
        return CompletableFuture.completedFuture(BspImpl$.MODULE$.scala$build$bsp$BspImpl$$$responseError(new StringBuilder(71).append("Workspace reload failed, inputs file missing from workspace directory: ").append(ideInputsJsonPath.toString()).toString(), BspImpl$.MODULE$.scala$build$bsp$BspImpl$$$responseError$default$2()));
    }

    private static final String prepareBuild$$anonfun$1$$anonfun$1() {
        return "Preparing build";
    }

    private static final boolean prepareBuild$$anonfun$1$$anonfun$2() {
        return true;
    }

    private final Either doBuildOnce$1(BloopSession currentBloopSession$2, BspReloadableOptions reloadableOptions$2, PreBuildData data, Scope scope) {
        return Build$.MODULE$.buildOnce(currentBloopSession$2.inputs(), data.sources(), data.generatedSources(), data.buildOptions(), scope, reloadableOptions$2.logger(), this.actualLocalClient, currentBloopSession$2.remoteServer(), (Option<Object>)None$.MODULE$).left().map((Function1 & Serializable)_$8 -> {
            BuildException buildException = (BuildException)Predef$.MODULE$.ArrowAssoc(_$8);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)buildException, (Object)scope);
        });
    }

    private static final String build$$anonfun$1(BuildException ex$1) {
        return new StringBuilder(37).append("Caught ").append(ex$1).append(" during BSP build, ignoring it").toString();
    }

    private final /* synthetic */ void showGlobalWarningOnce$$anonfun$1(String msg$1, String _$9) {
        ShowMessageParams params = new ShowMessageParams(MessageType.WARNING, msg$1);
        this.actualLocalClient.onBuildShowMessage(params);
    }

    private final void doPostProcess$1(BloopSession currentBloopSession$8, BspReloadableOptions reloadableOptions$8, PreBuildData data, Scope scope) {
        data.project().scalaCompiler().map((Function1 & Serializable)_$10 -> _$10.scalaVersion()).foreach((Function1)(JProcedure1 & Serializable)sv -> Build$.MODULE$.postProcess(data.generatedSources(), currentBloopSession$8.inputs().generatedSrcRoot(scope), data.classesDir(), reloadableOptions$8.logger(), currentBloopSession$8.inputs().workspace(), true, (String)sv).left().foreach((Function1)(JProcedure1 & Serializable)_$11 -> _$11.foreach((Function1)(JProcedure1 & Serializable)msg -> this.showGlobalWarningOnce((String)msg))));
    }

    private final BspServer bspServer$lzyINIT1$1(Inputs inputs$2, BspReloadableOptions reloadableOptions$11, boolean presetIntelliJ$1, Logger logger$2, BloopCompiler remoteServer$1, LazyRef bspServer$lzy1$1, LazyRef watcher$lzy1$1, LazyRef bloopSession0$lzy1$1) {
        BspServer bspServer;
        LazyRef lazyRef = bspServer$lzy1$1;
        synchronized (lazyRef) {
            bspServer = (BspServer)(bspServer$lzy1$1.initialized() ? bspServer$lzy1$1.value() : bspServer$lzy1$1.initialize((Object)new BspServer((BuildServer)remoteServer$1.bloopServer().server(), (Function1<Function0<CompletableFuture<CompileResult>>, CompletableFuture<CompileResult>>)(Function1 & Serializable)doCompile -> this.compile(this.bloopSession0$1(inputs$2, reloadableOptions$11, presetIntelliJ$1, logger$2, remoteServer$1, bspServer$lzy1$1, watcher$lzy1$1, bloopSession0$lzy1$1), this.threads.prepareBuildExecutor(), reloadableOptions$11, (Function0<CompletableFuture<CompileResult>>)doCompile), logger$2, presetIntelliJ$1)));
        }
        return bspServer;
    }

    private final BspServer bspServer$1(Inputs inputs$4, BspReloadableOptions reloadableOptions$13, boolean presetIntelliJ$3, Logger logger$4, BloopCompiler remoteServer$3, LazyRef bspServer$lzy1$3, LazyRef watcher$lzy1$3, LazyRef bloopSession0$lzy1$3) {
        return (BspServer)(bspServer$lzy1$3.initialized() ? bspServer$lzy1$3.value() : this.bspServer$lzyINIT1$1(inputs$4, reloadableOptions$13, presetIntelliJ$3, logger$4, remoteServer$3, bspServer$lzy1$3, watcher$lzy1$3, bloopSession0$lzy1$3));
    }

    private final void watcher$lzyINIT1$1$$anonfun$1(Inputs inputs$6, BspReloadableOptions reloadableOptions$15, boolean presetIntelliJ$5, Logger logger$6, BloopCompiler remoteServer$5, LazyRef bspServer$lzy1$5, LazyRef watcher$lzy1$5, LazyRef bloopSession0$lzy1$5) {
        this.build(this.bloopSession0$1(inputs$6, reloadableOptions$15, presetIntelliJ$5, logger$6, remoteServer$5, bspServer$lzy1$5, watcher$lzy1$5, bloopSession0$lzy1$5), this.actualLocalClient, true, reloadableOptions$15);
    }

    private static final void watcher$lzyINIT1$1$$anonfun$2() {
    }

    private final Build.Watcher watcher$lzyINIT1$1(Inputs inputs$5, BspReloadableOptions reloadableOptions$14, boolean presetIntelliJ$4, Logger logger$5, BloopCompiler remoteServer$4, LazyRef bspServer$lzy1$4, LazyRef watcher$lzy1$4, LazyRef bloopSession0$lzy1$4) {
        Build.Watcher watcher;
        LazyRef lazyRef = watcher$lzy1$4;
        synchronized (lazyRef) {
            watcher = (Build.Watcher)(watcher$lzy1$4.initialized() ? watcher$lzy1$4.value() : watcher$lzy1$4.initialize((Object)new Build.Watcher((ListBuffer<PathWatcher<PathWatchers.Event>>)((ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PathWatcher[0]))), this.threads.buildThreads().fileWatcher(), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.watcher$lzyINIT1$1$$anonfun$1(inputs$5, reloadableOptions$14, presetIntelliJ$4, logger$5, remoteServer$4, bspServer$lzy1$4, watcher$lzy1$4, bloopSession0$lzy1$4);
                return BoxedUnit.UNIT;
            }, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                BspImpl.watcher$lzyINIT1$1$$anonfun$2();
                return BoxedUnit.UNIT;
            })));
        }
        return watcher;
    }

    private final Build.Watcher watcher$1(Inputs inputs$7, BspReloadableOptions reloadableOptions$16, boolean presetIntelliJ$6, Logger logger$7, BloopCompiler remoteServer$6, LazyRef bspServer$lzy1$6, LazyRef watcher$lzy1$6, LazyRef bloopSession0$lzy1$6) {
        return (Build.Watcher)(watcher$lzy1$6.initialized() ? watcher$lzy1$6.value() : this.watcher$lzyINIT1$1(inputs$7, reloadableOptions$16, presetIntelliJ$6, logger$7, remoteServer$6, bspServer$lzy1$6, watcher$lzy1$6, bloopSession0$lzy1$6));
    }

    private final BloopSession bloopSession0$lzyINIT1$1(Inputs inputs$8, BspReloadableOptions reloadableOptions$17, boolean presetIntelliJ$7, Logger logger$8, BloopCompiler remoteServer$7, LazyRef bspServer$lzy1$7, LazyRef watcher$lzy1$7, LazyRef bloopSession0$lzy1$7) {
        BloopSession bloopSession;
        LazyRef lazyRef = bloopSession0$lzy1$7;
        synchronized (lazyRef) {
            bloopSession = (BloopSession)(bloopSession0$lzy1$7.initialized() ? bloopSession0$lzy1$7.value() : bloopSession0$lzy1$7.initialize((Object)BloopSession$.MODULE$.apply(inputs$8, remoteServer$7, this.bspServer$1(inputs$8, reloadableOptions$17, presetIntelliJ$7, logger$8, remoteServer$7, bspServer$lzy1$7, watcher$lzy1$7, bloopSession0$lzy1$7), this.watcher$1(inputs$8, reloadableOptions$17, presetIntelliJ$7, logger$8, remoteServer$7, bspServer$lzy1$7, watcher$lzy1$7, bloopSession0$lzy1$7))));
        }
        return bloopSession;
    }

    private final BloopSession bloopSession0$1(Inputs inputs$9, BspReloadableOptions reloadableOptions$18, boolean presetIntelliJ$8, Logger logger$9, BloopCompiler remoteServer$8, LazyRef bspServer$lzy1$8, LazyRef watcher$lzy1$8, LazyRef bloopSession0$lzy1$8) {
        return (BloopSession)(bloopSession0$lzy1$8.initialized() ? bloopSession0$lzy1$8.value() : this.bloopSession0$lzyINIT1$1(inputs$9, reloadableOptions$18, presetIntelliJ$8, logger$9, remoteServer$8, bspServer$lzy1$8, watcher$lzy1$8, bloopSession0$lzy1$8));
    }

    private static final String run$$anonfun$1() {
        boolean hasConsole;
        boolean bl = hasConsole = System.console() != null;
        if (hasConsole) {
            return "Listening to incoming JSONRPC BSP requests, press Ctrl+D to exit.";
        }
        return "Listening to incoming JSONRPC BSP requests.";
    }

    private static final String $anonfun$14$$anonfun$1(Throwable t$1) {
        return new StringBuilder(45).append("Caught ").append(t$1).append(" during initial BSP build, ignoring it").toString();
    }

    private static final BuildOptions.JavaHomeInfo projectJavaHome$lzyINIT1$1(PreBuildProject preBuildProject$1, LazyRef projectJavaHome$lzy1$1) {
        BuildOptions.JavaHomeInfo javaHomeInfo;
        LazyRef lazyRef = projectJavaHome$lzy1$1;
        synchronized (lazyRef) {
            javaHomeInfo = (BuildOptions.JavaHomeInfo)(projectJavaHome$lzy1$1.initialized() ? projectJavaHome$lzy1$1.value() : projectJavaHome$lzy1$1.initialize((Object)((BuildOptions.JavaHomeInfo)preBuildProject$1.mainScope().buildOptions().javaHome().value())));
        }
        return javaHomeInfo;
    }

    private static final BuildOptions.JavaHomeInfo projectJavaHome$1(PreBuildProject preBuildProject$2, LazyRef projectJavaHome$lzy1$2) {
        return (BuildOptions.JavaHomeInfo)(projectJavaHome$lzy1$2.initialized() ? projectJavaHome$lzy1$2.value() : BspImpl.projectJavaHome$lzyINIT1$1(preBuildProject$2, projectJavaHome$lzy1$2));
    }

    private final String $anonfun$17(PreBuildProject preBuildProject$4, LazyRef projectJavaHome$lzy1$4) {
        return new StringBuilder(64).append("Bloop JVM version too low, current ").append(((Positioned)this.bloopSession.get().remoteServer().jvmVersion().get()).value()).append(" expected ").append(BspImpl.projectJavaHome$1(preBuildProject$4, projectJavaHome$lzy1$4).version()).append(", restarting server").toString();
    }

    private static final String liftedTree1$1$$anonfun$1(Path ideInputsJsonPath$3, JsonReaderException e$1) {
        return new StringBuilder(23).append("Caught ").append((Object)e$1).append(" while decoding ").append(ideInputsJsonPath$3).toString();
    }

    private static final Either liftedTree1$1(Logger logger$14, Path ideInputsJsonPath$2) {
        Right right;
        try {
            right = package$.MODULE$.Right().apply(com.github.plokhotnyuk.jsoniter_scala.core.package$.MODULE$.readFromArray(read.bytes$.MODULE$.apply((ReadablePath)ideInputsJsonPath$2), com.github.plokhotnyuk.jsoniter_scala.core.package$.MODULE$.readFromArray$default$2(), IdeInputs$.MODULE$.codec()));
        }
        catch (JsonReaderException e) {
            logger$14.debug(() -> BspImpl.liftedTree1$1$$anonfun$1(ideInputsJsonPath$2, e));
            right = package$.MODULE$.Left().apply((Object)new ParsingInputsException(e.getMessage(), (Throwable)e));
        }
        return right;
    }

    public static final class LoggingBspClient
    implements LoggingBuildClient,
    BloopBuildClient {
        private final BspClient actualLocalClient;

        public LoggingBspClient(BspClient actualLocalClient) {
            this.actualLocalClient = actualLocalClient;
        }

        @Override
        public BspClient underlying() {
            return this.actualLocalClient;
        }

        @Override
        public void clear() {
            this.underlying().clear();
        }

        @Override
        public Option<scala.collection.immutable.Seq<Tuple2<Either<String, Path>, ch.epfl.scala.bsp4j.Diagnostic>>> diagnostics() {
            return this.underlying().diagnostics();
        }

        @Override
        public void setProjectParams(scala.collection.immutable.Seq<String> newParams) {
            this.underlying().setProjectParams(newParams);
        }

        @Override
        public void setGeneratedSources(Scope scope, scala.collection.immutable.Seq<GeneratedSource> newGeneratedSources) {
            this.underlying().setGeneratedSources(scope, (scala.collection.immutable.Seq)newGeneratedSources);
        }
    }

    public static final class PreBuildData
    implements Product,
    Serializable {
        private final Sources sources;
        private final BuildOptions buildOptions;
        private final Path classesDir;
        private final Option scalaParams;
        private final Artifacts artifacts;
        private final Project project;
        private final scala.collection.immutable.Seq generatedSources;
        private final boolean buildChanged;

        public static PreBuildData apply(Sources sources, BuildOptions buildOptions, Path path, Option<ScalaParameters> option, Artifacts artifacts, Project project, scala.collection.immutable.Seq<GeneratedSource> seq, boolean bl) {
            return BspImpl$PreBuildData$.MODULE$.apply(sources, buildOptions, path, option, artifacts, project, seq, bl);
        }

        public static PreBuildData fromProduct(Product product) {
            return BspImpl$PreBuildData$.MODULE$.fromProduct(product);
        }

        public static PreBuildData unapply(PreBuildData preBuildData) {
            return BspImpl$PreBuildData$.MODULE$.unapply(preBuildData);
        }

        public PreBuildData(Sources sources, BuildOptions buildOptions, Path classesDir, Option<ScalaParameters> scalaParams, Artifacts artifacts, Project project, scala.collection.immutable.Seq<GeneratedSource> generatedSources, boolean buildChanged) {
            this.sources = sources;
            this.buildOptions = buildOptions;
            this.classesDir = classesDir;
            this.scalaParams = scalaParams;
            this.artifacts = artifacts;
            this.project = project;
            this.generatedSources = generatedSources;
            this.buildChanged = buildChanged;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.sources()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.buildOptions()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.classesDir()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.scalaParams()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.artifacts()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.project()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.generatedSources()));
            n = Statics.mix((int)n, (int)(this.buildChanged() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)8);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PreBuildData)) return false;
            PreBuildData preBuildData = (PreBuildData)object;
            if (this.buildChanged() != preBuildData.buildChanged()) return false;
            Sources sources = this.sources();
            Sources sources2 = preBuildData.sources();
            if (sources == null) {
                if (sources2 != null) {
                    return false;
                }
            } else if (!((Object)sources).equals(sources2)) return false;
            BuildOptions buildOptions = this.buildOptions();
            BuildOptions buildOptions2 = preBuildData.buildOptions();
            if (buildOptions == null) {
                if (buildOptions2 != null) {
                    return false;
                }
            } else if (!buildOptions.equals(buildOptions2)) return false;
            Path path = this.classesDir();
            Path path2 = preBuildData.classesDir();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!path.equals(path2)) return false;
            Option<ScalaParameters> option = this.scalaParams();
            Option<ScalaParameters> option2 = preBuildData.scalaParams();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Artifacts artifacts = this.artifacts();
            Artifacts artifacts2 = preBuildData.artifacts();
            if (artifacts == null) {
                if (artifacts2 != null) {
                    return false;
                }
            } else if (!artifacts.equals(artifacts2)) return false;
            Project project = this.project();
            Project project2 = preBuildData.project();
            if (project == null) {
                if (project2 != null) {
                    return false;
                }
            } else if (!((Object)project).equals(project2)) return false;
            scala.collection.immutable.Seq<GeneratedSource> seq = this.generatedSources();
            scala.collection.immutable.Seq<GeneratedSource> seq2 = preBuildData.generatedSources();
            if (seq == null) {
                if (seq2 == null) return true;
                return false;
            } else {
                if (!seq.equals(seq2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PreBuildData;
        }

        public int productArity() {
            return 8;
        }

        public String productPrefix() {
            return "PreBuildData";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
                case 7: {
                    return BoxesRunTime.boxToBoolean((boolean)this._8());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "sources";
                }
                case 1: {
                    return "buildOptions";
                }
                case 2: {
                    return "classesDir";
                }
                case 3: {
                    return "scalaParams";
                }
                case 4: {
                    return "artifacts";
                }
                case 5: {
                    return "project";
                }
                case 6: {
                    return "generatedSources";
                }
                case 7: {
                    return "buildChanged";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Sources sources() {
            return this.sources;
        }

        public BuildOptions buildOptions() {
            return this.buildOptions;
        }

        public Path classesDir() {
            return this.classesDir;
        }

        public Option<ScalaParameters> scalaParams() {
            return this.scalaParams;
        }

        public Artifacts artifacts() {
            return this.artifacts;
        }

        public Project project() {
            return this.project;
        }

        public scala.collection.immutable.Seq<GeneratedSource> generatedSources() {
            return this.generatedSources;
        }

        public boolean buildChanged() {
            return this.buildChanged;
        }

        public PreBuildData copy(Sources sources, BuildOptions buildOptions, Path classesDir, Option<ScalaParameters> scalaParams, Artifacts artifacts, Project project, scala.collection.immutable.Seq<GeneratedSource> generatedSources, boolean buildChanged) {
            return new PreBuildData(sources, buildOptions, classesDir, scalaParams, artifacts, project, generatedSources, buildChanged);
        }

        public Sources copy$default$1() {
            return this.sources();
        }

        public BuildOptions copy$default$2() {
            return this.buildOptions();
        }

        public Path copy$default$3() {
            return this.classesDir();
        }

        public Option<ScalaParameters> copy$default$4() {
            return this.scalaParams();
        }

        public Artifacts copy$default$5() {
            return this.artifacts();
        }

        public Project copy$default$6() {
            return this.project();
        }

        public scala.collection.immutable.Seq<GeneratedSource> copy$default$7() {
            return this.generatedSources();
        }

        public boolean copy$default$8() {
            return this.buildChanged();
        }

        public Sources _1() {
            return this.sources();
        }

        public BuildOptions _2() {
            return this.buildOptions();
        }

        public Path _3() {
            return this.classesDir();
        }

        public Option<ScalaParameters> _4() {
            return this.scalaParams();
        }

        public Artifacts _5() {
            return this.artifacts();
        }

        public Project _6() {
            return this.project();
        }

        public scala.collection.immutable.Seq<GeneratedSource> _7() {
            return this.generatedSources();
        }

        public boolean _8() {
            return this.buildChanged();
        }
    }

    public static final class PreBuildProject
    implements Product,
    Serializable {
        private final PreBuildData mainScope;
        private final PreBuildData testScope;
        private final scala.collection.immutable.Seq diagnostics;

        public static PreBuildProject apply(PreBuildData preBuildData, PreBuildData preBuildData2, scala.collection.immutable.Seq<Diagnostic> seq) {
            return BspImpl$PreBuildProject$.MODULE$.apply(preBuildData, preBuildData2, seq);
        }

        public static PreBuildProject fromProduct(Product product) {
            return BspImpl$PreBuildProject$.MODULE$.fromProduct(product);
        }

        public static PreBuildProject unapply(PreBuildProject preBuildProject) {
            return BspImpl$PreBuildProject$.MODULE$.unapply(preBuildProject);
        }

        public PreBuildProject(PreBuildData mainScope, PreBuildData testScope, scala.collection.immutable.Seq<Diagnostic> diagnostics) {
            this.mainScope = mainScope;
            this.testScope = testScope;
            this.diagnostics = diagnostics;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PreBuildProject)) return false;
            PreBuildProject preBuildProject = (PreBuildProject)object;
            PreBuildData preBuildData = this.mainScope();
            PreBuildData preBuildData2 = preBuildProject.mainScope();
            if (preBuildData == null) {
                if (preBuildData2 != null) {
                    return false;
                }
            } else if (!((Object)preBuildData).equals(preBuildData2)) return false;
            PreBuildData preBuildData3 = this.testScope();
            PreBuildData preBuildData4 = preBuildProject.testScope();
            if (preBuildData3 == null) {
                if (preBuildData4 != null) {
                    return false;
                }
            } else if (!((Object)preBuildData3).equals(preBuildData4)) return false;
            scala.collection.immutable.Seq<Diagnostic> seq = this.diagnostics();
            scala.collection.immutable.Seq<Diagnostic> seq2 = preBuildProject.diagnostics();
            if (seq == null) {
                if (seq2 == null) return true;
                return false;
            } else {
                if (!seq.equals(seq2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PreBuildProject;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "PreBuildProject";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "mainScope";
                }
                case 1: {
                    return "testScope";
                }
                case 2: {
                    return "diagnostics";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public PreBuildData mainScope() {
            return this.mainScope;
        }

        public PreBuildData testScope() {
            return this.testScope;
        }

        public scala.collection.immutable.Seq<Diagnostic> diagnostics() {
            return this.diagnostics;
        }

        public PreBuildProject copy(PreBuildData mainScope, PreBuildData testScope, scala.collection.immutable.Seq<Diagnostic> diagnostics) {
            return new PreBuildProject(mainScope, testScope, diagnostics);
        }

        public PreBuildData copy$default$1() {
            return this.mainScope();
        }

        public PreBuildData copy$default$2() {
            return this.testScope();
        }

        public scala.collection.immutable.Seq<Diagnostic> copy$default$3() {
            return this.diagnostics();
        }

        public PreBuildData _1() {
            return this.mainScope();
        }

        public PreBuildData _2() {
            return this.testScope();
        }

        public scala.collection.immutable.Seq<Diagnostic> _3() {
            return this.diagnostics();
        }
    }
}

