/*
 * Decompiled with CFR 0.152.
 */
package scala.build.compiler;

import bloop.rifle.BloopServer;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Some$;
import scala.build.Bloop$;
import scala.build.Logger;
import scala.build.Position;
import scala.build.Positioned;
import scala.build.Positioned$;
import scala.build.Project;
import scala.build.compiler.ScalaCompiler;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class BloopCompiler
implements ScalaCompiler {
    private final Function0<BloopServer> createServer;
    private final FiniteDuration buildTargetsTimeout;
    private final boolean strictBloopJsonCheck;
    private BloopServer currentBloopServer;

    public BloopCompiler(Function0<BloopServer> createServer, FiniteDuration buildTargetsTimeout, boolean strictBloopJsonCheck) {
        this.createServer = createServer;
        this.buildTargetsTimeout = buildTargetsTimeout;
        this.strictBloopJsonCheck = strictBloopJsonCheck;
        this.currentBloopServer = (BloopServer)createServer.apply();
    }

    public BloopServer bloopServer() {
        return this.currentBloopServer;
    }

    @Override
    public Option<Positioned<Object>> jvmVersion() {
        return Some$.MODULE$.apply((Object)Positioned$.MODULE$.apply((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Position.Bloop[]{Position.Bloop$.MODULE$.apply(this.bloopServer().bloopInfo().javaHome())})), (Object)BoxesRunTime.boxToInteger((int)this.bloopServer().bloopInfo().jvmVersion())));
    }

    @Override
    public boolean prepareProject(Project project, Logger logger) {
        return project.writeBloopFile(this.strictBloopJsonCheck, logger);
    }

    @Override
    public boolean compile(Project project, Logger logger) {
        return this.helper$1(project, logger, 2);
    }

    @Override
    public void shutdown() {
        this.bloopServer().shutdown();
    }

    private static final String helper$1$$anonfun$1(Throwable ex$1) {
        return new StringBuilder(55).append("Seems Bloop server exited (got ").append(ex$1).append("), trying to restart one").toString();
    }

    private final boolean helper$1(Project project$1, Logger logger$1, int remainingAttempts) {
        Either<Throwable, Object> either;
        block2: {
            Throwable ex;
            while (true) {
                if ((either = Bloop$.MODULE$.compile(project$1.projectName(), this.bloopServer().server(), logger$1, this.buildTargetsTimeout)) instanceof Right) {
                    boolean res = BoxesRunTime.unboxToBoolean((Object)((Right)either).value());
                    return res;
                }
                if (!(either instanceof Left)) break block2;
                ex = (Throwable)((Left)either).value();
                if (remainingAttempts <= 1) break;
                logger$1.debug(() -> BloopCompiler.helper$1$$anonfun$1(ex));
                this.currentBloopServer = (BloopServer)this.createServer.apply();
                --remainingAttempts;
            }
            throw new Exception("Seems compilation server exited, and wasn't able to restart one", ex);
        }
        throw new MatchError(either);
    }
}

